<?php
include 'koneksi.php';
include 'auth.php';
include 'akses_ditolak.php';

if ($_SESSION['user']['role'] !== 'admin') {
  aksesDitolak();
}

$nama = $_SESSION['user']['nama'];

// Ambil nama_asli + foto
$stmt = $koneksi->prepare("SELECT nama_asli, foto FROM user WHERE nama = ? LIMIT 1");
$stmt->bind_param("s", $nama);
$stmt->execute();
$res = $stmt->get_result()->fetch_assoc();
$nama_asli = $res['nama_asli'] ?? $_SESSION['user']['nama_asli'] ?? '';
$foto_db   = $res['foto']      ?? '';
$stmt->close();

// Cek foto
$foto_path = '';
if (!empty($foto_db)) {
  $path = 'uploads/' . $foto_db;
  if (file_exists($path)) $foto_path = $path;
}
?>
<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Menu Admin | TIOR Delivery</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <style>
    /* ============================== */
    /* ROOT THEME FROM INDEX.PHP */
    /* ============================== */
    :root {
      --bg-navy: #071733;
      --card-blue: #1f4f82;
      --card-inner: #163e6b;
      --yellow: #ffd800;
      --muted: #eef3f7;
      --gold-light: #ffe680;
      --gold-dark: #d1a700;
    }

    /* ============================== */
    /* BODY */
    /* ============================== */
    body {
      margin: 0;
      background: var(--bg-navy);
      color: #fff;
      font-family: 'Segoe UI', Roboto, Arial, sans-serif;
    }

    /* ============================== */
    /* HEADER MINI (diambil dari index.php) */
    /* ============================== */
    .header-mini {
      background: rgba(173, 196, 255, 0.20);
      backdrop-filter: blur(18px) saturate(160%);
      -webkit-backdrop-filter: blur(18px) saturate(160%);
      padding: 14px 18px;
      margin: 18px 16px 0 16px;
      border-radius: 15px;
      border: 1.4px solid rgba(255, 255, 255, 0.45);
      box-shadow:
        inset 0 1px 3px rgba(255, 255, 255, 0.35),
        inset 0 -1px 3px rgba(120, 80, 0, 0.20),
        0 8px 20px rgba(0, 0, 0, 0.22),
        0 0 12px rgba(255, 200, 60, 0.22);
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .mini-logo {
      width: 130px;
    }

    /* Button Menu Driver */
    .wa-btn {
      background: linear-gradient(var(--gold-light), #ffcc00);
      border: none;
      padding: 10px 20px;
      border-radius: 14px;
      color: #04003a;
      font-weight: 700;
      box-shadow:
        0 6px 0 var(--gold-dark),
        0 4px 10px rgba(0, 0, 0, 0.25),
        inset 0 3px 4px rgba(255, 255, 255, 0.45);
      transition: .22s;
    }

    .wa-btn:hover {
      transform: translateY(-3px);
    }

    .wa-btn:active {
      transform: translateY(2px);
    }

    /* ============================== */
    /* GREETING BOX PREMIUM */
    /* ============================== */
    .greet-box {
      margin: 16px;
      background: rgba(173, 196, 255, 0.20);
      padding: 14px 18px;
      border-radius: 15px;
      border: 1.4px solid rgba(255, 255, 255, 0.45);
      backdrop-filter: blur(18px) saturate(160%);
      -webkit-backdrop-filter: blur(18px) saturate(160%);
      box-shadow:
        inset 0 1px 3px rgba(255, 255, 255, 0.35),
        inset 0 -1px 3px rgba(120, 80, 0, 0.20),
        0 8px 20px rgba(0, 0, 0, 0.22),
        0 0 12px rgba(255, 200, 60, 0.22);
      display: flex;
      gap: 14px;
      align-items: center;
    }

    .profile-photo {
      width: 50px;
      height: 50px;
      border-radius: 50%;
      overflow: hidden;
      background: #707070;
      border: 2px solid rgba(255, 255, 255, 0.10);
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .profile-photo img {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }

    .greet-text h1 {
      margin: 0;
      font-weight: 700;
      font-size: 18px;
      color: #ffd800;
    }

    .greet-text p {
      margin: 2px 0 0 0;
      font-size: 12px;
      color: rgba(255, 255, 255, 0.85);
    }

    /* ============================== */
    /* MENU CARD (SAMA DENGAN main-card index.php) */
    /* ============================== */
    .menu-container {
      width: 92%;
      max-width: 360px;
      margin: 18px auto;
      background: #233a6a;
      border-radius: 14px;
      padding: 18px;
      box-shadow: 0 10px 0 rgba(0, 0, 0, 0.35);
      border: 4px solid rgba(255, 255, 255, 0.06);
    }

    /* GRID MENU */
    .menu-grid {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      gap: 20px;
      justify-items: center;
    }

    /* BUTTON GOLD PREMIUM */
    .menu-btn {
      background: linear-gradient(var(--gold-light), #ffcc00);
      border-radius: 14px;
      width: 80px;
      font-size: 24px;
      height: 70px;
      padding: 5px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      color: #04003a;
      font-weight: 700;
      border: none;
      box-shadow:
        0 6px 0 var(--gold-dark),
        0 4px 10px rgba(0, 0, 0, 0.18),
        inset 0 2px 4px rgba(255, 255, 255, 0.4);
      transition: transform .22s, box-shadow .22s;
    }

    .menu-btn:hover {
      transform: translateY(-3px);
      box-shadow:
        0 9px 0 var(--gold-dark),
        0 6px 14px rgba(0, 0, 0, 0.24),
        inset 0 2px 5px rgba(255, 255, 255, 0.45);
    }

    .menu-btn:active {
      transform: translateY(2px);
    }

    /* label */
    .menu-label {
      margin-top: 10px;
      font-size: 10px;
      color: #ffd800;
      font-weight: 600;
      text-align: center;
    }

    .menu-item {
      text-align: center;
    }

    .logo-box {
      width: 100%;
      display: flex;
      justify-content: left;
      /* horizontal tengah */
      align-items: center;
      /* vertical tengah */
      margin: 20px 20px 5px 10px;
      /* jarak atas-bawah (kecil) */
    }

    .header-mini {
      background: #071733;
      /* navy dark seperti contoh */
      padding: 10px 14px;
      display: flex;
      border: 3px solid rgba(255, 255, 255, 0.24);
      align-items: center;
      justify-content: space-between;
      /* kiri & kanan */
      border-radius: 10px;
      margin: 10px 15px 0 15px;
      /* jarak kiri kanan */
      box-shadow: 0 1px 0 rgba(226, 223, 223, 0.3);
    }

    .mini-left {
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .mini-logo {
      width: 130px;
      height: auto;
      object-fit: contain;
    }

    .mini-title {
      color: #d1a700;
      font-size: 16px;
      font-weight: 600;
    }

    .wa-btn {
      background: #233a6a;
      /* biru gelap */
      border: none;
      padding: 8px 14px;
      color: #ffd800;
      /* kuning gold */
      font-size: 14px;
      border-radius: 8px;
      font-weight: 500;

      /* soft 3D */
      box-shadow:
        inset 0 -3px 0 rgba(0, 0, 0, 0.25),
        0 3px 6px rgba(0, 0, 0, 0.25);

      /* Transition lembut */
      transition:
        background 200ms ease,
        transform 200ms cubic-bezier(.2, .8, .3, 1),
        box-shadow 200ms ease;
    }

    /* Hover efek lembut premium */
    .wa-btn:hover {
      background: #2a4a8a;
      /* biru sedikit lebih terang */
      transform: translateY(-2px);
      /* naik sedikit */
      box-shadow:
        inset 0 -3px 0 rgba(0, 0, 0, 0.2),
        0 6px 12px rgba(0, 0, 0, 0.28);
      /* shadow lebih “halus” */
    }

    /* Active (klik) */
    .wa-btn:active {
      transform: translateY(1px);
      box-shadow:
        inset 0 -3px 0 rgba(0, 0, 0, 0.3),
        0 2px 4px rgba(0, 0, 0, 0.22);
    }


    .wa-btn:active {
      transform: translateY(2px);
    }

    /* SweetAlert2 - Navy Glassmorphism + Margin */
    .swal2-popup {
      background: rgba(30, 45, 80, 0.35) !important;
      backdrop-filter: blur(14px) !important;
      -webkit-backdrop-filter: blur(14px) !important;
      /* Margin agar ada jarak dari sisi layar */
      margin-left: 500px !important;
      margin-right: 500px !important;
      border: 2px solid rgba(90, 120, 180, 0.4);
      border-radius: 16px;
      color: #ffffff !important;
      font-size: 16px;
      box-shadow: 0 100px 28px rgba(0, 0, 0, 0.35);
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    /* Judul popup */
    .swal2-title {
      font-size: 20px;
      color: #ffffffff;
      text-align: center;
    }

    /* Input fields */
    .swal2-input {
      width: 100%;
      max-width: 250px;
      margin: 8px auto;
      background-color: #1e2329 !important;
      color: #ffffff !important;
      border: 1px solid #444 !important;
      border-radius: 8px;
      padding: 10px 12px;
      box-sizing: border-box;
    }

    /* Base styling untuk semua tombol SweetAlert */
    .swal2-styled {
      padding: 14px 26px !important;
      font-size: 17px !important;
      font-weight: 700 !important;
      border-radius: 14px !important;
      backdrop-filter: blur(10px) !important;
      -webkit-backdrop-filter: blur(10px) !important;
      box-shadow:
        0 10px 18px rgba(0, 0, 0, 0.35),
        inset 0 5px 8px rgba(255, 255, 255, 0.22),
        inset 0 -5px 8px rgba(0, 0, 0, 0.30);
      transition: 0.22s ease !important;
    }

    /* Hover umum */
    .swal2-styled:hover {
      transform: translateY(-3px);
    }

    /* Active umum */
    .swal2-styled:active {
      transform: translateY(3px);
    }

    /* --------------------------- */
    /*  STAY (Hijau Glass)         */
    /* --------------------------- */
    .swal2-confirm {
      background: rgba(40, 150, 80, 0.45) !important;
      /* hijau transparan */
      border: 2px solid rgba(120, 230, 160, 0.5) !important;
      color: #fff !important;
      box-shadow:
        0 10px 18px rgba(0, 0, 0, 0.35),
        inset 0 6px 10px rgba(255, 255, 255, 0.20),
        inset 0 -6px 10px rgba(0, 0, 0, 0.35);
    }

    .swal2-confirm:hover {
      background: rgba(55, 180, 110, 0.55) !important;
    }

    /* --------------------------- */
    /*  OFF (Merah Glass)          */
    /* --------------------------- */
    .swal2-deny {
      background: rgba(180, 40, 60, 0.45) !important;
      /* merah transparan */
      border: 2px solid rgba(255, 150, 150, 0.5) !important;
      color: #fff !important;
    }

    .swal2-deny:hover {
      background: rgba(210, 55, 80, 0.55) !important;
    }

    /* --------------------------- */
    /*  Batal (Hitam Glass)        */
    /* --------------------------- */
    .swal2-cancel {
      background: rgba(20, 20, 20, 0.45) !important;
      /* hitam transparan */
      border: 2px solid rgba(180, 180, 180, 0.4) !important;
      color: #fff !important;
    }

    .swal2-cancel:hover {
      background: rgba(40, 40, 40, 0.55) !important;
    }


    /* Tombol shift 3D - Glass Navy Cembung */
    .swal-shift-btn {
      padding: 16px 20px;
      min-width: 80px;
      font-size: 18px;
      font-weight: 700;
      color: #ffffff;

      /* Tambahkan jarak antar tombol */
      margin: 0 6px;

      /* Glass navy */
      background: rgba(40, 60, 110, 0.45);
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);

      border-radius: 18px;
      border: 2px solid rgba(180, 200, 255, 0.45);

      cursor: pointer;
      transition: 0.22s ease;

      /* --- Efek 3D tonjol keluar --- */
      box-shadow:
        0 12px 18px rgba(0, 0, 0, 0.45),
        inset 0 6px 10px rgba(255, 255, 255, 0.25),
        inset 0 -6px 10px rgba(0, 0, 0, 0.35),
        0 0 14px rgba(90, 120, 200, 0.5);
    }

    /* Hover: makin menonjol */
    .swal-shift-btn:hover {
      transform: translateY(-4px);
      box-shadow:
        0 16px 22px rgba(0, 0, 0, 0.55),
        inset 0 7px 11px rgba(255, 255, 255, 0.28),
        inset 0 -7px 11px rgba(0, 0, 0, 0.4),
        0 0 16px rgba(110, 140, 230, 0.6);
    }

    /* Active: ditekan */
    .swal-shift-btn:active {
      transform: translateY(3px);
      box-shadow:
        0 7px 10px rgba(0, 0, 0, 0.45),
        inset 0 3px 6px rgba(255, 255, 255, 0.18),
        inset 0 -4px 7px rgba(0, 0, 0, 0.35),
        0 0 12px rgba(90, 120, 200, 0.45);
    }

    /* Hilangkan garis animasi */
    .swal2-success-ring,
    .swal2-success-fix {
      background: none !important;
      display: none !important;
    }

    /* Hapus inner circle */
    .swal2-success-circular-line-left,
    .swal2-success-circular-line-right {
      display: none !important;
    }
  </style>
</head>

<body>

  <!-- HEADER MINI -->
  <div class="header-mini">
    <img src="img/tior.png" class="mini-logo">

    <button class="wa-btn" onclick="pindahMenuDriver()">
      Menu Driver
    </button>

  </div>

  <!-- GREETING BOX -->
  <div class="greet-box">
    <div class="profile-photo">
      <?php if ($foto_path): ?>
        <img src="<?= $foto_path ?>">
      <?php else: ?>
        <i class="fa-solid fa-user" style="font-size:26px;color:#163e6b;"></i>
      <?php endif; ?>
    </div>

    <div class="greet-text">
      <h1>Hi, <?= htmlspecialchars($nama_asli) ?></h1>
      <p id="tanggal-saat-ini"></p>
    </div>
  </div>

  <!-- MENU CARD -->
  <div class="menu-container">
    <div class="menu-grid">

      <div class="menu-item">
        <button class="menu-btn" onclick="window.location.href='data_driver.php'">
          <i class="fa-solid fa-user-plus"></i>
        </button>
        <div class="menu-label">Menu Member</div>
      </div>

      <div class="menu-item">
        <button class="menu-btn" onclick="window.location.href='report_stay.php'">
          <i class="fa-solid fa-motorcycle"></i>
        </button>
        <div class="menu-label">Standby</div>
      </div>

      <div class="menu-item">
        <button class="menu-btn" onclick="window.location.href='catat_absen.php'">
          <i class="fa-solid fa-user-clock"></i>
        </button>
        <div class="menu-label">Absensi</div>
      </div>

      <div class="menu-item">
        <button class="menu-btn" onclick="window.location.href='report_orderan.php'">
          <i class="fa-solid fa-file-lines"></i>
        </button>
        <div class="menu-label">Report</div>
      </div>

      <div class="menu-item">
        <button class="menu-btn" onclick="window.location.href='total_orderan_mingguan.php'">
          <i class="fa-solid fa-line-chart"></i>
        </button>
        <div class="menu-label">Pencapaian</div>
      </div>

      <div class="menu-item">
        <button class="menu-btn" onclick="window.location.href='total_order.php'">
          <i class="fa-solid fa-trophy"></i>
        </button>
        <div class="menu-label">TIOR Loyality</div>
      </div>

    </div>
  </div>

  <script>
    // tanggal otomatis
    const t = new Date();
    const hari = t.toLocaleString('id-ID', {
      weekday: "long"
    });
    document.getElementById('tanggal-saat-ini').innerText =
      `${hari}, ${t.getDate()} ${t.toLocaleString('id-ID',{month:"long"})} ${t.getFullYear()}`;

    function confirmLogout() {
      Swal.fire({
        title: "Yakin ingin logout?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Ya, Logout",
        cancelButtonText: "Batal"
      }).then(r => {
        if (r.isConfirmed) {
          localStorage.removeItem("userSession");
          window.location.href = "logout.php";
        }
      });
    }

    function pindahMenuDriver() {
      Swal.fire({
        title: "Beralih Ke...",
        text: "Menu Driver",
        imageUrl: "img/head.png", // <- icon pintu kamu
        imageWidth: 80,
        imageHeight: 80,
        showConfirmButton: false,
        timer: 1200,
        timerProgressBar: true
      });

      setTimeout(() => {
        window.location.href = "index.php";
      }, 800);
    }
  </script>

</body>

</html>