<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Cek Ongkir</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="css/navbar.css">

    <style>
        body {
            margin: 0;
            background: #071733;
            font-family: 'Segoe UI', Roboto, Arial;
            color: #fff;
        }

        /* =====================
       HEADER MINI ATAS
    ======================*/
        .header-mini {
            background: #071733;
            padding: 10px 14px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border: 3px solid rgba(255, 255, 255, 0.24);
            border-radius: 10px;
            margin: 15px;
            box-shadow: 0 1px 0 rgba(226, 223, 223, 0.3);
        }

        .mini-logo {
            width: 130px;
            object-fit: contain;
        }

        .wa-btn {
            background: #233a6a;
            border: none;
            padding: 8px 14px;
            color: #ffd800;
            font-size: 14px;
            border-radius: 8px;
            font-weight: 500;
            box-shadow: inset 0 -3px 0 rgba(0, 0, 0, 0.25), 0 3px 6px rgba(0, 0, 0, 0.25);
            transition: 0.2s;
        }

        .wa-btn:hover {
            background: #2a4a8a;
            transform: translateY(-2px);
            box-shadow: inset 0 -3px 0 rgba(0, 0, 0, 0.2), 0 6px 12px rgba(0, 0, 0, 0.28);
        }

        /* CARD UTAMA */
        .main-card {
            max-width: 360px;
            margin: 15px 15px 15px 15px;
            background: #233a6a;
            padding: 20px;
            border-radius: 14px;
            border: 4px solid rgba(255, 255, 255, 0.06);
            box-shadow: 0 10px 0 rgba(0, 0, 0, 0.35);
            text-align: center;
        }

        .title {
            font-size: 22px;
            font-weight: 700;
            color: #ffd800;
            margin-bottom: 20px;
        }

        /* INPUT KACA NAVY */
        #km {
            width: 100%;
            padding: 16px;
            border-radius: 12px;
            background: rgba(255, 255, 255, 0.91);
            border: 1px solid rgba(255, 255, 255, 0.25);
            color: rgba(0, 0, 0, 1);
            font-size: 18px;
            backdrop-filter: blur(8px);
            margin-bottom: 16px;
            text-align: center;
        }

        #km:focus {
            border: 1px solid #ffd800;
            box-shadow: 0 0 6px rgba(255, 200, 60, 0.7);
            outline: none;
        }

        /* TOMBOL 3D KUNING */
        .gold-btn {
            background: linear-gradient(#ffe680, #ffcc00);
            color: #04003a;
            border: none;
            padding: 12px;
            width: 100%;
            border-radius: 12px;
            font-weight: 700;
            text-decoration: none;
            margin-top: 15px;
            display: inline-block;
            box-shadow:
                0 6px 0 #d1a700,
                0 4px 10px rgba(0, 0, 0, 0.18),
                inset 0 2px 4px rgba(255, 255, 255, 0.45);
            transition: 0.2s;
        }

        .gold-btn:hover {
            transform: translateY(-3px);
            box-shadow:
                0 9px 0 #d1a700,
                0 6px 14px rgba(0, 0, 0, 0.24),
                inset 0 2px 5px rgba(255, 255, 255, 0.5);
        }

        .gold-btn:active {
            transform: translateY(2px);
        }

        /* TOMBOL BARANG & PENUMPANG */
        .type-btn {
            padding: 13px;
            border: none;
            border-radius: 12px;
            font-weight: 700;
            font-size: 15px;
            width: 100%;
            color: #0d0d0d;
            background: linear-gradient(#d9e3ff, #9bb5ff);
            box-shadow:
                0 5px 0 #6c7fcc,
                inset 0 2px 4px rgba(255, 255, 255, 0.45);
            transition: 0.2s;
        }

        .type-btn:hover {
            transform: translateY(-3px);
        }

        /* ACTIVE */
        .active-btn {
            outline: 3px solid #ffd800;
            box-shadow: 0 0 12px rgba(255, 200, 60, 0.8);
        }

        /* HASIL */
        .hasil-box {
            background: #1f4f82;
            border-radius: 12px;
            border: 3px solid rgba(255, 255, 255, 0.2);
            padding: 18px;
            margin-top: 16px;
            box-shadow:
                inset 0 1px 3px rgba(255, 255, 255, 0.35),
                0 6px 12px rgba(0, 0, 0, 0.25);
            font-size: 18px;
            font-weight: 700;
            display: none;
        }

        #labelPilihan {
            margin-top: 12px;
            color: #ffd800;
            font-size: 15px;
            display: none;
        }

        input:-webkit-autofill,
        input:-webkit-autofill:hover,
        input:-webkit-autofill:focus {
            -webkit-box-shadow: 0 0 0 30px rgba(255, 255, 255, 0) inset !important;
            -webkit-text-fill-color: #101010ff !important;
        }

        /* SweetAlert2 - Navy Glassmorphism + Margin */
        .swal2-popup {
            background: rgba(30, 45, 80, 0.35) !important;
            backdrop-filter: blur(14px) !important;
            -webkit-backdrop-filter: blur(14px) !important;
            /* Margin agar ada jarak dari sisi layar */
            margin-left: 500px !important;
            margin-right: 500px !important;
            border: 2px solid rgba(90, 120, 180, 0.4);
            border-radius: 16px;
            color: #ffffff !important;
            font-size: 16px;
            box-shadow: 0 100px 28px rgba(0, 0, 0, 0.35);
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        /* Judul popup */
        .swal2-title {
            font-size: 20px;
            color: #ffffffff;
            text-align: center;
        }

        /* Input fields */
        .swal2-input {
            width: 100%;
            max-width: 250px;
            margin: 8px auto;
            background-color: #1e2329 !important;
            color: #ffffff !important;
            border: 1px solid #444 !important;
            border-radius: 8px;
            padding: 10px 12px;
            box-sizing: border-box;
        }

        /* Base styling untuk semua tombol SweetAlert */
        .swal2-styled {
            padding: 14px 26px !important;
            font-size: 17px !important;
            font-weight: 700 !important;
            border-radius: 14px !important;
            backdrop-filter: blur(10px) !important;
            -webkit-backdrop-filter: blur(10px) !important;
            box-shadow:
                0 10px 18px rgba(0, 0, 0, 0.35),
                inset 0 5px 8px rgba(255, 255, 255, 0.22),
                inset 0 -5px 8px rgba(0, 0, 0, 0.30);
            transition: 0.22s ease !important;
        }

        /* Hover umum */
        .swal2-styled:hover {
            transform: translateY(-3px);
        }

        /* Active umum */
        .swal2-styled:active {
            transform: translateY(3px);
        }

        /* --------------------------- */
        /*  STAY (Hijau Glass)         */
        /* --------------------------- */
        .swal2-confirm {
            background: rgba(40, 150, 80, 0.45) !important;
            /* hijau transparan */
            border: 2px solid rgba(120, 230, 160, 0.5) !important;
            color: #fff !important;
            box-shadow:
                0 10px 18px rgba(0, 0, 0, 0.35),
                inset 0 6px 10px rgba(255, 255, 255, 0.20),
                inset 0 -6px 10px rgba(0, 0, 0, 0.35);
        }

        .swal2-confirm:hover {
            background: rgba(55, 180, 110, 0.55) !important;
        }

        /* --------------------------- */
        /*  OFF (Merah Glass)          */
        /* --------------------------- */
        .swal2-deny {
            background: rgba(180, 40, 60, 0.45) !important;
            /* merah transparan */
            border: 2px solid rgba(255, 150, 150, 0.5) !important;
            color: #fff !important;
        }

        .swal2-deny:hover {
            background: rgba(210, 55, 80, 0.55) !important;
        }

        /* --------------------------- */
        /*  Batal (Hitam Glass)        */
        /* --------------------------- */
        .swal2-cancel {
            background: rgba(20, 20, 20, 0.45) !important;
            /* hitam transparan */
            border: 2px solid rgba(180, 180, 180, 0.4) !important;
            color: #fff !important;
        }

        .swal2-cancel:hover {
            background: rgba(40, 40, 40, 0.55) !important;
        }


        /* Tombol shift 3D - Glass Navy Cembung */
        .swal-shift-btn {
            padding: 16px 20px;
            min-width: 80px;
            font-size: 18px;
            font-weight: 700;
            color: #ffffff;

            /* Tambahkan jarak antar tombol */
            margin: 0 6px;

            /* Glass navy */
            background: rgba(40, 60, 110, 0.45);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);

            border-radius: 18px;
            border: 2px solid rgba(180, 200, 255, 0.45);

            cursor: pointer;
            transition: 0.22s ease;

            /* --- Efek 3D tonjol keluar --- */
            box-shadow:
                0 12px 18px rgba(0, 0, 0, 0.45),
                inset 0 6px 10px rgba(255, 255, 255, 0.25),
                inset 0 -6px 10px rgba(0, 0, 0, 0.35),
                0 0 14px rgba(90, 120, 200, 0.5);
        }

        /* Hover: makin menonjol */
        .swal-shift-btn:hover {
            transform: translateY(-4px);
            box-shadow:
                0 16px 22px rgba(0, 0, 0, 0.55),
                inset 0 7px 11px rgba(255, 255, 255, 0.28),
                inset 0 -7px 11px rgba(0, 0, 0, 0.4),
                0 0 16px rgba(110, 140, 230, 0.6);
        }

        /* Active: ditekan */
        .swal-shift-btn:active {
            transform: translateY(3px);
            box-shadow:
                0 7px 10px rgba(0, 0, 0, 0.45),
                inset 0 3px 6px rgba(255, 255, 255, 0.18),
                inset 0 -4px 7px rgba(0, 0, 0, 0.35),
                0 0 12px rgba(90, 120, 200, 0.45);
        }

        /* Hilangkan garis animasi */
        .swal2-success-ring,
        .swal2-success-fix {
            background: none !important;
            display: none !important;
        }

        /* Hapus inner circle */
        .swal2-success-circular-line-left,
        .swal2-success-circular-line-right {
            display: none !important;
        }
    </style>
</head>

<body>

    <!-- HEADER MINI -->
    <div class="header-mini">
        <img src="img/tior.png" class="mini-logo">
        <button class="wa-btn" onclick="window.location.href='index.php'">Home</button>
    </div>

    <!-- CARD -->
    <div class="main-card">

        <div class="title">Cek Ongkir</div>

        <input type="text" id="km"
            placeholder="Masukkan jarak (km)"
            oninput="formatKM()"
            autocomplete="new-password"
            autocorrect="off"
            autocapitalize="off"
            spellcheck="false"
            inputmode="numeric">


        <div class="d-flex gap-2">
            <button class="type-btn" id="btnBarang" onclick="hitungBarang()">Barang</button>
            <button class="type-btn" id="btnPenumpang" onclick="hitungPenumpang()">Penumpang</button>
        </div>

        <a class="gold-btn" onclick="resetForm()">Reset</a>

        <h6 id="labelPilihan"></h6>

        <div id="hasil" class="hasil-box"></div>

    </div>

    <h6 style="text-align:center; margin-top:10px; padding:0 20px 0 20px; color:#ccc;">
        Harap berikan tarif ongkir yang sesuai dengan aplikasi
    </h6>

    <script>
        function formatKM() {
            let input = document.getElementById("km");
            let val = input.value.replace(/[^0-9]/g, "");
            input.value = val ? val + " km" : "";
        }

        function getJarak() {
            let raw = document.getElementById("km").value.replace(/[^0-9]/g, "");
            let jarak = parseFloat(raw);

            if (!jarak || jarak <= 0) {
                Swal.fire("Error", "Masukkan jarak yang valid!", "error");
                return false;
            }
            return jarak;
        }

        // =====================
        // HITUNG ONGKIR BARANG
        // =====================
        function hitungBarang() {
            let jarak = getJarak();
            if (!jarak) return;

            setActive("barang");

            let baseKm = 4;
            let basePrice = 12000;
            let perKm = 2000;

            let ongkir = jarak <= baseKm ?
                basePrice :
                basePrice + ((jarak - baseKm) * perKm);

            tampilkanHasil(ongkir);
        }

        // =====================
        function hitungPenumpang() {
            let jarak = getJarak();
            if (!jarak) return;

            setActive("penumpang");

            let baseKm = 4;
            let basePrice = 10000;
            let perKm = 1000;

            let ongkir = jarak <= baseKm ?
                basePrice :
                basePrice + ((jarak - baseKm) * perKm);

            tampilkanHasil(ongkir);
        }

        // =====================
        function tampilkanHasil(ongkir) {
            const hasilEl = document.getElementById("hasil");
            hasilEl.style.display = "block";
            hasilEl.innerHTML = "Total Ongkir: Rp " + ongkir.toLocaleString("id-ID");

            Swal.fire({
                icon: 'success',
                title: 'Berhasil!',
                text: 'Total Ongkir: Rp ' + ongkir.toLocaleString("id-ID"),
                timer: 500,
                showConfirmButton: false
            });
        }

        // =====================
        function resetForm() {
            document.getElementById("km").value = "";
            document.getElementById("hasil").style.display = "none";
            document.getElementById("hasil").innerHTML = "";

            document.getElementById("btnBarang").classList.remove("active-btn");
            document.getElementById("btnPenumpang").classList.remove("active-btn");

            const label = document.getElementById("labelPilihan");
            label.style.display = "none";
            label.innerHTML = "";
        }

        // =====================
        function setActive(type) {
            const btnBarang = document.getElementById("btnBarang");
            const btnPenumpang = document.getElementById("btnPenumpang");
            const label = document.getElementById("labelPilihan");

            btnBarang.classList.remove("active-btn");
            btnPenumpang.classList.remove("active-btn");

            if (type === "barang") {
                btnBarang.classList.add("active-btn");
                label.innerHTML = "Tarif Antar Barang";
            } else {
                btnPenumpang.classList.add("active-btn");
                label.innerHTML = "Tarif Antar Penumpang";
            }

            label.style.display = "block";
        }
    </script>
</body>

</html>