<?php
session_start();
include "koneksi.php";
?>
<!DOCTYPE html>
<html lang="id">

<head>
<meta charset="utf-8">
<title>Daftar Akun • ELD Delivery</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- SweetAlert -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- FontAwesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">

<style>
/* BACKGROUND MEWAH */
body{
    margin:0;
    font-family:'Poppins', sans-serif;
    background: linear-gradient(180deg, #071733 0%, #0c1f45 40%, #102a5e 70%, #0c1b35 100%);
    min-height:100vh;
    padding-bottom:60px;   /* ⬅ Menambah jarak bawah */
    color:#fff;
    display:flex;
    flex-direction:column;
    align-items:center;
}


@keyframes fadeIn{
    from{ opacity:0; transform:translateY(15px); }
    to{ opacity:1; transform:translateY(0); }
}

/* LOGO */
.logo{
    width:55%;
    max-width:230px;
    margin-top:40px;
}

/* WRAPPER CARD */
.daftar-card{
    width:92%;
    max-width:350px;
    margin: 10px auto;  /* ⬅ Jarak kanan-kiri & atas-bawah */
    padding:28px 5px;  /* ⬅ Tambah padding biar tidak mepet */

    background: rgba(35,58,106,0.88);
    border-radius:16px;
    border:3px solid rgba(255,255,255,0.15);

    box-shadow:
        0 12px 0 rgba(0,0,0,0.35),
        inset 0 2px 4px rgba(255,255,255,0.25);

    backdrop-filter: blur(14px);
    -webkit-backdrop-filter: blur(14px);
    text-align:center;
}


/* TITLE */
.daftar-title{
    font-size:26px;
    font-weight:700;
    color:#ffd800;
    margin-bottom:20px;
}

/* Bungkus input biar tidak terlalu panjang */
.input-group{
    width: 90%;                /* tidak full 100% */
    max-width: 300px;          /* lebar ideal */
    margin: 0 auto 15px auto;  /* center + spacing */
    position: relative;
}

/* Input serasi dengan login dan tidak melebar */
.daftar-input{
    width: 100%;
    padding: 14px 14px 14px 42px;
    border-radius: 12px;
    background: rgba(255,255,255,0.13);
    border: 2px solid rgba(255,255,255,0.25);
    color: #fff;
    font-size: 15px;

    box-sizing: border-box;  /* mencegah input melebar */
}

.daftar-input::placeholder{
    color: rgba(255,255,255,0.7);
}

.input-icon{
    position: absolute;
    left: 13px;
    top: 50%;
    transform: translateY(-50%);
    color: #ffd800;
    font-size: 18px;
    opacity: 0.8;
}


/* Input daftar sama seperti input login */
.daftar-input{
    width:100%;
    padding:14px 14px 14px 42px;  /* kiri 42px agar tidak terlalu kiri */
    border-radius:12px;
    background:rgba(255,255,255,0.13);
    border:2px solid rgba(255,255,255,0.25);
    color:#fff;
    font-size:15px;

}

.daftar-input::placeholder{
    color:rgba(255,255,255,0.7);
}

.daftar-input:focus{
    outline:none;
    border-color:#ffd800;
    box-shadow:0 0 8px rgba(255,215,80,0.7);
}

/* GOLD BUTTON */
.gold-btn{
    width:90%;
    padding:14px;
    margin-top:10px;

    border:none;
    border-radius:14px;
    background:linear-gradient(#ffe680,#ffcc00);
    color:#04003a;
    font-weight:700;
    font-size:18px;

    box-shadow:
        0 6px 0 #d1a700,
        0 4px 10px rgba(0,0,0,0.18),
        inset 0 3px 4px rgba(255,255,255,0.45);

    transition:0.22s;
}

.gold-btn:hover{
    transform:translateY(-3px);
    box-shadow:
        0 9px 0 #d1a700,
        0 6px 14px rgba(0,0,0,0.24),
        inset 0 2px 5px rgba(255,255,255,0.5);
}

.gold-btn:active{
    transform:translateY(2px);
    box-shadow:
        0 3px 0 #d1a700,
        0 2px 6px rgba(0,0,0,0.22),
        inset 0 4px 6px rgba(0,0,0,0.25);
}

/* REGISTER LINK */
.login-link{
    margin-top:14px;
    font-size:14px;
}

.login-link a{
    color:#ffd800;
    font-weight:600;
}

/* FOOTER */
.footer{
    margin-top:35px;
    color:#ffd800;
    font-size:14px;
}

/* SweetAlert2 - Navy Glassmorphism + Margin */
.swal2-popup {
  background: rgba(30, 45, 80, 0.35) !important;
  backdrop-filter: blur(14px) !important;
  -webkit-backdrop-filter: blur(14px) !important;
  /* Margin agar ada jarak dari sisi layar */
  margin-left: 500px !important;
  margin-right: 500px !important;
  border: 2px solid rgba(90, 120, 180, 0.4);
  border-radius: 16px;
  color: #ffffff !important;
  font-size: 16px;
  box-shadow: 0 100px 28px rgba(0, 0, 0, 0.35);
  display: flex;
  flex-direction: column;
  align-items: center;
}

    /* Judul popup */
    .swal2-title {
      font-size: 20px;
      color: #ffffffff;
      text-align: center;
    }

    /* Input fields */
    .swal2-input {
      width: 100%;
      max-width: 250px;
      margin: 8px auto;
      background-color: #1e2329 !important;
      color: #ffffff !important;
      border: 1px solid #444 !important;
      border-radius: 8px;
      padding: 10px 12px;
      box-sizing: border-box;
    }

/* Base styling untuk semua tombol SweetAlert */
.swal2-styled {
  padding: 14px 26px !important;
  font-size: 17px !important;
  font-weight: 700 !important;
  border-radius: 14px !important;
  backdrop-filter: blur(10px) !important;
  -webkit-backdrop-filter: blur(10px) !important;
  box-shadow:
      0 10px 18px rgba(0, 0, 0, 0.35),
      inset 0 5px 8px rgba(255, 255, 255, 0.22),
      inset 0 -5px 8px rgba(0, 0, 0, 0.30);
  transition: 0.22s ease !important;
}

/* Hover umum */
.swal2-styled:hover {
  transform: translateY(-3px);
}

/* Active umum */
.swal2-styled:active {
  transform: translateY(3px);
}

/* --------------------------- */
/*  STAY (Hijau Glass)         */
/* --------------------------- */
.swal2-confirm {
  background: rgba(40, 150, 80, 0.45) !important; /* hijau transparan */
  border: 2px solid rgba(120, 230, 160, 0.5) !important;
  color: #fff !important;
  box-shadow:
      0 10px 18px rgba(0, 0, 0, 0.35),
      inset 0 6px 10px rgba(255, 255, 255, 0.20),
      inset 0 -6px 10px rgba(0, 0, 0, 0.35);
}

.swal2-confirm:hover {
  background: rgba(55, 180, 110, 0.55) !important;
}

/* --------------------------- */
/*  OFF (Merah Glass)          */
/* --------------------------- */
.swal2-deny {
  background: rgba(180, 40, 60, 0.45) !important; /* merah transparan */
  border: 2px solid rgba(255, 150, 150, 0.5) !important;
  color: #fff !important;
}

.swal2-deny:hover {
  background: rgba(210, 55, 80, 0.55) !important;
}

/* --------------------------- */
/*  Batal (Hitam Glass)        */
/* --------------------------- */
.swal2-cancel {
  background: rgba(20, 20, 20, 0.45) !important; /* hitam transparan */
  border: 2px solid rgba(180, 180, 180, 0.4) !important;
  color: #fff !important;
}

.swal2-cancel:hover {
  background: rgba(40, 40, 40, 0.55) !important;
}

    
/* Tombol shift 3D - Glass Navy Cembung */
.swal-shift-btn {
  padding: 16px 20px;
  min-width: 80px;
  font-size: 18px;
  font-weight: 700;
  color: #ffffff;

  /* Tambahkan jarak antar tombol */
  margin: 0 6px;

  /* Glass navy */
  background: rgba(40, 60, 110, 0.45);
  backdrop-filter: blur(10px);
  -webkit-backdrop-filter: blur(10px);

  border-radius: 18px;
  border: 2px solid rgba(180, 200, 255, 0.45);

  cursor: pointer;
  transition: 0.22s ease;

  /* --- Efek 3D tonjol keluar --- */
  box-shadow:
      0 12px 18px rgba(0, 0, 0, 0.45),
      inset 0 6px 10px rgba(255, 255, 255, 0.25),
      inset 0 -6px 10px rgba(0, 0, 0, 0.35),
      0 0 14px rgba(90, 120, 200, 0.5);
}

/* Hover: makin menonjol */
.swal-shift-btn:hover {
  transform: translateY(-4px);
  box-shadow:
      0 16px 22px rgba(0, 0, 0, 0.55),
      inset 0 7px 11px rgba(255, 255, 255, 0.28),
      inset 0 -7px 11px rgba(0, 0, 0, 0.4),
      0 0 16px rgba(110, 140, 230, 0.6);
}

/* Active: ditekan */
.swal-shift-btn:active {
  transform: translateY(3px);
  box-shadow:
      0 7px 10px rgba(0, 0, 0, 0.45),
      inset 0 3px 6px rgba(255, 255, 255, 0.18),
      inset 0 -4px 7px rgba(0, 0, 0, 0.35),
      0 0 12px rgba(90, 120, 200, 0.45);
}
/* Base styling untuk semua tombol SweetAlert */
.swal2-popup .swal2-styled {
  padding: 14px 26px !important;
  font-size: 17px !important;
  font-weight: 700 !important;
  border-radius: 14px !important;
  backdrop-filter: blur(10px) !important;
  -webkit-backdrop-filter: blur(10px) !important;
  box-shadow:
      0 10px 18px rgba(0, 0, 0, 0.35),
      inset 0 5px 8px rgba(255, 255, 255, 0.22),
      inset 0 -5px 8px rgba(0, 0, 0, 0.30);
  transition: 0.22s ease !important;
}

/* Hover khusus SweetAlert */
.swal2-popup .swal2-styled:hover {
  transform: translateY(-3px);
}

/* Active khusus SweetAlert */
.swal2-popup .swal2-styled:active {
  transform: translateY(3px);
}

/* STAY / OK (Hijau Glass) */
/* SweetAlert Confirm (OK) tengah sempurna */
.swal2-popup .swal2-confirm {
  background: rgba(40, 150, 80, 0.45) !important;
  border: 2px solid rgba(120, 230, 160, 0.5) !important;
  color: #fff !important;

  padding: 14px 28px !important; /* lebih seimbang */

  /* perbaikan posisi text */
  display: flex !important;
  align-items: center !important;
  justify-content: center !important;

  /* efek glass 3D tapi tidak membuat teks turun */
  box-shadow:
      0 6px 12px rgba(0, 0, 0, 0.35),        /* bayangan bawah dikurangi */
      inset 0 4px 7px rgba(255, 255, 255, 0.25), /* highlight atas */
      inset 0 -3px 6px rgba(0, 0, 0, 0.25);      /* shading bawah dikurangi */
}

/* OFF (Merah Glass) */
.swal2-popup .swal2-deny {
  background: rgba(180, 40, 60, 0.45) !important;
  border: 2px solid rgba(255, 150, 150, 0.5) !important;
  color: #fff !important;
}

/* Batal (Hitam Glass) */
.swal2-popup .swal2-cancel {
  background: rgba(20, 20, 20, 0.45) !important;
  border: 2px solid rgba(180, 180, 180, 0.4) !important;
  color: #fff !important;
}

/* Hilangkan garis animasi */
.swal2-success-ring,
.swal2-success-fix {
  background: none !important;
  display: none !important;
}

/* Hapus inner circle */
.swal2-success-circular-line-left,
.swal2-success-circular-line-right {
  display: none !important;
}
</style>
</head>

<body>

<img src="img/tior.png" class="logo">

<?php
// === VALIDASI PHP (dibersihkan, tetap memakai SweetAlert) ===
if (isset($_POST['no_handphone'])) {

    $nama = trim($_POST['nama']);
    $no = trim($_POST['no_handphone']);
    $pw  = trim($_POST['password']);

    if (substr($no,0,2) != "08"){
        echo "<script>Swal.fire({icon:'error',title:'Nomor salah',text:'Nomor WA harus mulai 08',timer:2000,showConfirmButton:false});</script>";
    }
    elseif(strlen($no) < 8){
        echo "<script>Swal.fire({icon:'error',title:'Nomor salah',text:'Nomor minimal 8 digit',timer:2000,showConfirmButton:false});</script>";
    }
    elseif(strlen($pw) < 5){
        echo "<script>Swal.fire({icon:'error',title:'Password salah',text:'Minimal 5 karakter',timer:2000,showConfirmButton:false});</script>";
    }
    else{
        $cek = mysqli_query($koneksi,"SELECT * FROM user WHERE no_handphone='$no'");
        if (mysqli_num_rows($cek)==0){
            echo "<script>Swal.fire({icon:'error',title:'Tidak Ditemukan',text:'Nomor tidak ada di database',timer:2000,showConfirmButton:false});</script>";
        } else{
            $d = mysqli_fetch_assoc($cek);
            if (!empty($d['password'])){
                echo "<script>Swal.fire({icon:'error',title:'Sudah Terdaftar',text:'Nomor ini sudah memiliki akun',timer:2000,showConfirmButton:false});</script>";
            } else{
                $save = mysqli_query($koneksi,"UPDATE user SET nama='$nama',password='$pw' WHERE no_handphone='$no'");
                if ($save){
                    echo "<script>
                        Swal.fire({icon:'success',title:'Berhasil!',text:'Akun berhasil dibuat',timer:1200,showConfirmButton:false})
                        .then(()=>{location.href='login.php';});
                    </script>";
                }
            }
        }
    }
}
?>

<!-- CARD FORM DAFTAR -->
<form class="daftar-card" method="post">

    <div class="daftar-title">DAFTAR</div>

    <div class="input-group">
        <i class="fa fa-user input-icon"></i>
        <input type="text" class="daftar-input" name="nama" placeholder="Nama lengkap" required>
    </div>

    <div class="input-group">
        <i class="fa fa-phone input-icon"></i>
        <input type="tel" class="daftar-input" name="no_handphone" placeholder="Nomor Whatsapp" required>
    </div>

    <div class="input-group">
        <i class="fa fa-lock input-icon"></i>
        <input type="password" class="daftar-input" name="password" placeholder="Password" required>
    </div>

    <div style="text-align:left;width:90%;margin:10px auto 15px auto;">
        <label>
            <input type="checkbox" name="setuju" required>
            Data yang saya isi sudah benar
        </label>
    </div>

    <button type="submit" class="gold-btn">Daftar</button>

    <div class="login-link">
        Sudah punya akun? <a href="login.php">Login</a>
    </div>

</form>

<div class="footer">© 2025 TIOR DELIVERY</div>

</body>
</html>
