<?php
include 'koneksi.php';
include 'auth.php';
include 'akses_ditolak.php';

$cari = isset($_GET['cari']) ? $_GET['cari'] : '';

/* ===========================
   TAMBAH MEMBER (INSERT)
   =========================== */
if (isset($_POST['simpan'])) {

  $nama = mysqli_real_escape_string($koneksi, $_POST['nama']);
  $hp   = mysqli_real_escape_string($koneksi, $_POST['no_handphone']);
  $role = mysqli_real_escape_string($koneksi, $_POST['role']);

  $q = "INSERT INTO user (nama_asli, no_handphone, role)
          VALUES ('$nama', '$hp', '$role')";

  if (mysqli_query($koneksi, $q)) {
    header("Location: data_driver.php?add=success");
    exit;
  } else {
    header("Location: data_driver.php?add=fail");
    exit;
  }
}

/* ===========================
   EDIT MEMBER (UPDATE)
   =========================== */
if (isset($_POST['update'])) {

  $id   = $_POST['edit_id'];

  // Ambil role asli user yang akan diupdate
  $cekUser = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT role FROM user WHERE id='" . intval($id) . "'"));

  if ($cekUser) {
    $role_asli = $cekUser['role'];
  } else {
    // User tidak ditemukan
    header("Location: data_driver.php?edit=fail");
    exit;
  }

  // Cegah edit admin sepenuhnya
  if ($role_asli === 'admin') {
    header("Location: data_driver.php?edit=denied");
    exit;
  }

  $nama = mysqli_real_escape_string($koneksi, $_POST['edit_nama']);
  $hp   = mysqli_real_escape_string($koneksi, $_POST['edit_no_hp']);
  $role = mysqli_real_escape_string($koneksi, $_POST['edit_role']);
  $pass = mysqli_real_escape_string($koneksi, $_POST['edit_password']);

  // Jika role asli admin, cegah penurunan (redundant karena di atas kita tolak edit admin,
  // tapi tetap aman jika logika diubah nanti)
  if ($role_asli === 'admin' && $role !== 'admin') {
    header("Location: data_driver.php?edit=role_denied");
    exit;
  }

  $q = "UPDATE user SET 
            nama_asli = '$nama',
            no_handphone = '$hp',
            role = '$role',
            password = '$pass'
          WHERE id = '" . intval($id) . "'";

  if (mysqli_query($koneksi, $q)) {
    header("Location: data_driver.php?edit=success");
    exit;
  } else {
    header("Location: data_driver.php?edit=fail");
    exit;
  }
}

/* ===========================
   HAPUS MEMBER (DELETE)
   =========================== */
if (isset($_POST['hapus_id'])) {

  $id = $_POST['hapus_id'];

  // Cek role user yang akan dihapus
  $cek = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT role FROM user WHERE id='" . intval($id) . "'"));

  if (!$cek) {
    header("Location: data_driver.php?hapus=fail");
    exit;
  }

  if ($cek['role'] === 'admin') {
    header("Location: data_driver.php?hapus=denied");
    exit;
  }

  $q = "DELETE FROM user WHERE id = '" . intval($id) . "'";

  if (mysqli_query($koneksi, $q)) {
    header("Location: data_driver.php?hapus=success");
    exit;
  } else {
    header("Location: data_driver.php?hapus=fail");
    exit;
  }
}

/* ===========================
   Ambil Data Untuk Tabel
   =========================== */
$totalQuery = "SELECT COUNT(*) as total FROM user";
$totalResult = mysqli_query($koneksi, $totalQuery);
$totalData = mysqli_fetch_assoc($totalResult)['total'];

$filteredQuery = "SELECT * FROM user 
                  WHERE nama_asli LIKE '%" . mysqli_real_escape_string($koneksi, $cari) . "%' 
                  OR role LIKE '%" . mysqli_real_escape_string($koneksi, $cari) . "%' 
                  ORDER BY nama_asli ASC";
$filteredResult = mysqli_query($koneksi, $filteredQuery);
$filteredCount = mysqli_num_rows($filteredResult);
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Data Driver</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link rel="stylesheet" href="css/navbar.css">

  <style>
    /* =============================
       (tetapkan semua CSS Anda seperti semula)
       =============================*/
    body {
      font-family: 'Segoe UI', Roboto, Arial;
      margin: 10px;
      padding: 0;
      background: #071733;
      color: #1e2329;
    }

    input::placeholder {
      text-align: center;
      color: #959595;
    }

    button {
      border: none;
      border-radius: 8px;
      background: linear-gradient(#ffe680, #ffcc00);
      color: #1e2329;
      font-weight: bold;
      height: 50px;
      transition: .2s;
      box-shadow: 0 6px 0 #d1a700, 0 4px 10px rgba(0, 0, 0, .18), inset 0 2px 4px rgba(255, 255, 255, .45);
    }

    button:hover {
      transform: translateY(-3px);
    }

    button:active {
      transform: translateY(2px);
    }

    .total-box {
      margin-top: 20px;
      background: #233a6a;
      padding: 15px;
      border-radius: 8px;
      border: 4px solid rgba(255, 255, 255, 0.06);
      box-shadow: 0 10px 0 rgba(0, 0, 0, 0.35);
      backdrop-filter: blur(14px);
    }

    .total-box input {
      width: 100%;
      padding: 10px;
      border-radius: 8px;
    }

    .search-row {
      display: flex;
      gap: 10px;
    }

    .btn-center {
      text-align: center;
      margin-top: 12px;
    }

    .btn-center button {
      width: 60%;
    }

    .table-container {
      max-height: 45vh;
      overflow-y: auto;
      margin-top: 10px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      background: #ececec;
    }

    thead th {
      background: #233a6a;
      color: #fed054;
      position: sticky;
      top: 0;
      padding: 6px;
      font-size: 12px;
    }

    td,
    th {
      padding: 6px;
      text-align: center;
      border: 1px solid rgba(255, 255, 255, 0.5);
    }

    td.nama {
      max-width: 110px;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      cursor: pointer;
    }

    .swal2-popup {
      background: rgba(30, 45, 80, 0.35) !important;
      backdrop-filter: blur(14px) !important;
      -webkit-backdrop-filter: blur(14px) !important;
      margin-left: 500px !important;
      margin-right: 500px !important;
      border: 2px solid rgba(90, 120, 180, 0.4);
      border-radius: 16px;
      color: #ffffff !important;
      font-size: 16px;
      box-shadow: 0 100px 28px rgba(0, 0, 0, 0.35);
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    .swal2-title {
      font-size: 20px;
      color: #ffffffff;
      text-align: center;
    }

    .swal2-input {
      width: 100%;
      max-width: 250px;
      margin: 8px auto;
      background-color: #1e2329 !important;
      color: #ffffff !important;
      border: 1px solid #444 !important;
      border-radius: 8px;
      padding: 10px 12px;
      box-sizing: border-box;
    }

    .swal2-styled {
      padding: 14px 26px !important;
      font-size: 17px !important;
      font-weight: 700 !important;
      border-radius: 14px !important;
      backdrop-filter: blur(10px) !important;
      -webkit-backdrop-filter: blur(10px) !important;
      box-shadow: 0 10px 18px rgba(0, 0, 0, 0.35), inset 0 5px 8px rgba(255, 255, 255, 0.22), inset 0 -5px 8px rgba(0, 0, 0, 0.30);
      transition: 0.22s ease !important;
    }

    .swal2-styled:hover {
      transform: translateY(-3px);
    }

    .swal2-styled:active {
      transform: translateY(3px);
    }

    .swal2-confirm {
      background: rgba(40, 150, 80, 0.45) !important;
      border: 2px solid rgba(120, 230, 160, 0.5) !important;
      color: #fff !important;
      box-shadow: 0 10px 18px rgba(0, 0, 0, 0.35), inset 0 6px 10px rgba(255, 255, 255, 0.20), inset 0 -6px 10px rgba(0, 0, 0, 0.35);
    }

    .swal2-deny {
      background: rgba(180, 40, 60, 0.45) !important;
      border: 2px solid rgba(255, 150, 150, 0.5) !important;
      color: #fff !important;
    }

    .swal2-cancel {
      background: rgba(20, 20, 20, 0.45) !important;
      border: 2px solid rgba(180, 180, 180, 0.4) !important;
      color: #fff !important;
    }

    .swal-shift-btn {
      padding: 16px 20px;
      min-width: 80px;
      font-size: 12px;
      font-weight: 700;
      color: #ffffff;
      margin: 0 6px;
      background: rgba(40, 60, 110, 0.45);
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      border-radius: 18px;
      border: 2px solid rgba(180, 200, 255, 0.45);
      cursor: pointer;
      transition: 0.22s ease;
      box-shadow: 0 12px 18px rgba(0, 0, 0, 0.45), inset 0 6px 10px rgba(255, 255, 255, 0.25), inset 0 -6px 10px rgba(0, 0, 0, 0.35), 0 0 14px rgba(90, 120, 200, 0.5);
    }

    .swal-shift-btn:hover {
      transform: translateY(-4px);
      box-shadow: 0 16px 22px rgba(0, 0, 0, 0.55), inset 0 7px 11px rgba(255, 255, 255, 0.28), inset 0 -7px 11px rgba(0, 0, 0, 0.4), 0 0 16px rgba(110, 140, 230, 0.6);
    }

    .swal-shift-btn:active {
      transform: translateY(3px);
      box-shadow: 0 7px 10px rgba(0, 0, 0, 0.45), inset 0 3px 6px rgba(255, 255, 255, 0.18), inset 0 -4px 7px rgba(0, 0, 0, 0.35), 0 0 12px rgba(90, 120, 200, 0.45);
    }

    .swal2-success-ring,
    .swal2-success-fix {
      background: none !important;
      display: none !important;
    }

    .swal2-success-circular-line-left,
    .swal2-success-circular-line-right {
      display: none !important;
    }

    h4 {
      text-align: center;
      color: #fed054;
      margin: 20px 0;
    }

    .total-member-box {
      margin-top: 12px;
      padding: 5px;
      background: #233a6a;
      border-radius: 8px;
      border: 4px solid rgba(255, 255, 255, 0.06);
      box-shadow: 0 10px 0 rgba(0, 0, 0, 0.35);
      backdrop-filter: blur(14px);
      color: #fed054;
      font-weight: bold;
      text-align: center;
      font-size: 15px;
    }

    .aksi-center {
      display: flex;
      justify-content: center;
      align-items: center;
      margin-bottom: 5px;
    }

    .aksi-btn {
      height: 20px;
      width: 20px;
      font-size: 15px;
      border-radius: 5px;
      cursor: pointer;
    }

    .search-row {
      display: flex;
      gap: 10px;
      align-items: center;
    }

    .search-row input {
      height: 45px;
      border-radius: 8px;
      padding: 0 10px;
      font-size: 14px;
    }

    .search-row button {
      height: 40px !important;
      border-radius: 8px;
      font-size: 14px;
    }

    .action-box {
      margin-top: 12px;
      background: #233a6a;
      padding: 10px;
      border-radius: 8px;
      border: 4px solid rgba(255, 255, 255, 0.06);
      box-shadow: 0 10px 0 rgba(0, 0, 0, 0.35);
      backdrop-filter: blur(14px);
      display: flex;
      gap: 10px;
      justify-content: center;
    }

    .action-box button {
      width: 45%;
      height: 45px !important;
      font-size: 14px;
    }
  </style>
</head>

<body>

  <h4>MEMBER TIOR DELIVERY</h4>

  <!-- SEARCH FORM -->
  <div class="total-box">
    <form onsubmit="return handleSearch();" style="width:100%;">
      <div class="search-row">
        <input type="text" id="cariInput" name="cari"
          placeholder="Cari nama / Section..."
          value="<?= htmlspecialchars($cari) ?>">
        <button type="submit" style="height:45px;width:90px;">Cari</button>
      </div>
    </form>
  </div>

  <!-- BOX TOMBOL ACTION -->
  <div class="action-box">
    <button type="button" id="btnTambah">Tambah Anggota</button>

    <?php if (!empty($cari)): ?>
      <button type="button" onclick="window.location='data_driver.php'">Reset Filter</button>
    <?php else: ?>
      <button type="button" disabled style="opacity:0.4;cursor:not-allowed;">Reset Filter</button>
    <?php endif; ?>
  </div>

  <!-- TOTAL MEMBER -->
  <div class="total-member-box">
    Total Anggota : <?= $totalData ?>
    &nbsp;
  </div>

  <!-- TABLE -->
  <div class="table-container">
    <table>
      <thead>
        <tr>
          <th>Nama</th>
          <th>Whatsapp</th>
          <th>Role</th>
          <th>Aksi</th>
          <th>Password</th>
        </tr>
      </thead>
      <tbody>

        <?php if ($filteredCount):
          while ($row = mysqli_fetch_assoc($filteredResult)): ?>
            <tr>
              <td class="nama"
                data-id="<?= $row['id'] ?>"
                data-nama="<?= htmlspecialchars($row['nama_asli']) ?>"
                data-hp="<?= htmlspecialchars($row['no_handphone']) ?>"
                data-role="<?= htmlspecialchars($row['role']) ?>"
                data-bank="<?= htmlspecialchars($row['bank']) ?>"
                data-rek="<?= htmlspecialchars($row['no_rek']) ?>"
                data-an="<?= htmlspecialchars($row['a_n']) ?>"
                data-foto="<?= htmlspecialchars($row['foto']) ?>">
                <?= htmlspecialchars($row['nama_asli']) ?>
              </td>
              <td><?= htmlspecialchars($row['no_handphone']) ?></td>
              <td><?= htmlspecialchars($row['role']) ?></td>

              <td>
                <div class="aksi-center">
                  <!-- sertakan data-role di tombol -->
                  <button class="aksi-btn"
                    data-id="<?= $row['id'] ?>"
                    data-nama="<?= htmlspecialchars($row['nama_asli']) ?>"
                    data-hp="<?= htmlspecialchars($row['no_handphone']) ?>"
                    data-role="<?= htmlspecialchars($row['role']) ?>"
                    data-password="<?= htmlspecialchars($row['password']) ?>">
                  </button>
                </div>
              </td>

              <td class="pw"
                data-pw="<?= $row['password'] ?>"
                data-role="<?= $row['role'] ?>"
                data-nama="<?= $row['nama_asli'] ?>">
                <?php if ($row['role'] === 'admin'): ?>
                  <i class="fa-solid fa-lock"></i>
                <?php else: ?>
                  ••••••
                <?php endif; ?>

              </td>
            </tr>
          <?php endwhile;
        else: ?>
          <tr>
            <td colspan="5">Tidak ada data</td>
          </tr>
        <?php endif; ?>

      </tbody>
    </table>
  </div>

  <?php include 'navbar4.php'; ?>

  <script>
    function handleSearch() {
      let c = cariInput.value.trim();
      if (c === "") {
        window.location = 'data_driver.php';
        return false;
      }
      return true;
    }

    /* Klik Nama → tampil full */
    document.querySelectorAll(".nama").forEach(el => {

      el.onclick = () => {

        let nama = el.dataset.nama;
        let hp = el.dataset.hp;
        let role = el.dataset.role;
        let bank = el.dataset.bank;
        let rek = el.dataset.rek;
        let an = el.dataset.an;

        let fotoDB = el.dataset.foto;
        let foto = "img/head.png";

        if (fotoDB && fotoDB.trim() !== "") {
          if (fotoDB.startsWith("http")) {
            foto = fotoDB;
          } else if (fotoDB.includes("/") || fotoDB.includes("\\")) {
            foto = fotoDB;
          } else {
            foto = "uploads/" + fotoDB;
          }
        }

        let htmlCard = `
      <div style="
        padding: 15px;
        border-radius: 16px;
        backdrop-filter: blur(18px);
        background: rgba(255,255,255,0.06);
        border: 1px solid rgba(255,255,255,0.15);
        box-shadow: 0 8px 20px rgba(0,0,0,0.35);
        text-align: left;
      ">
        <div style="text-align:center; margin-bottom:15px;">
          <img src="${foto}" onerror="this.src='img/head.png'" style="
            width:130px; height:130px;
            object-fit:cover;
            border-radius:50%;
            border:3px solid rgba(255,255,255,0.4);
            box-shadow:0 4px 10px rgba(0,0,0,0.35);
          ">
        </div>
        <div style="color:#fff; font-size:16px; line-height:1.6;">
          <b style="color:#fed054;">Nama:</b> ${nama}<br>
          <b style="color:#fed054;">Whatsapp:</b> ${hp}<br>
          <b style="color:#fed054;">Role:</b> ${role}<br>
          <b style="color:#fed054;">Bank:</b> ${bank}<br>
          <b style="color:#fed054;">No. Rekening:</b> ${rek}<br>
          <b style="color:#fed054;">A/N:</b> ${an}<br>
        </div>
      </div>
    `;

        Swal.fire({
          title: "Profil Anggota",
          html: htmlCard,
          width: 350,
          showConfirmButton: true,
          confirmButtonText: "Tutup",
          background: "transparent",
        });

      };

    });


    /* -------------------------
       TAMBAH MEMBER (SweetAlert)
       ------------------------- */
    document.getElementById("btnTambah").onclick = () => {

      Swal.fire({
        title: "Tambah Member",
        html: `
      <input id="tNama" class="swal2-input" placeholder="Nama">
      <input id="tHp" class="swal2-input" placeholder="No Handphone">
      <select id="tRole" class="swal2-input">
        <option value="">Pilih Role</option>
        <option value="driver">Driver</option>
        <option value="leader">Leader</option>
        <option value="admin">Admin</option>
      </select>
    `,
        showCancelButton: true,
        confirmButtonText: "Simpan",
        cancelButtonText: "Batal",
        preConfirm: () => {
          let nama = tNama.value.trim();
          let hp = tHp.value.trim();
          let role = tRole.value.trim();

          if (!nama || !hp || !role) {
            Swal.showValidationMessage("Semua field wajib diisi");
            return false;
          }
          return {
            nama,
            hp,
            role
          };
        }
      }).then(res => {
        if (res.isConfirmed) {

          const f = document.createElement("form");
          f.method = "POST";

          ["nama", "no_handphone", "role", "simpan"].forEach((n, i) => {
            let input = document.createElement("input");
            input.type = "hidden";
            input.name = n;
            input.value = i == 0 ? res.value.nama : i == 1 ? res.value.hp : i == 2 ? res.value.role : 1;
            f.appendChild(input);
          });

          document.body.appendChild(f);
          f.submit();
        }
      });

    };


    /* -------------------------
       EDIT / HAPUS MEMBER
       ------------------------- */
    document.querySelectorAll(".aksi-btn").forEach(btn => {
      btn.onclick = () => {

        const d = {
          id: btn.dataset.id,
          nama: btn.dataset.nama,
          hp: btn.dataset.hp,
          role: btn.dataset.role,
          pass: btn.dataset.password
        };

        Swal.fire({
          title: "Pilih Aksi",
          html: `
        <div style="
          display:flex;
          gap:10px;
          margin-top:20px;
        ">
          <button id="btnEdit" class="swal-shift-btn" style="flex:1; background:rgba(40,150,80,0.45); border-color:rgba(120,230,160,0.5);">
            Edit
          </button>

          <button id="btnHapus" class="swal-shift-btn" style="flex:1; background:rgba(180,40,60,0.45); border-color:rgba(255,150,150,0.5);">
            Hapus
          </button>

          <button id="btnBatal" class="swal-shift-btn" style="flex:1; background:rgba(40,40,40,0.45); border-color:rgba(180,180,180,0.45);">
            Batal
          </button>
        </div>
      `,
          showConfirmButton: false,
          background: "transparent",
          width: 380
        });

        setTimeout(() => {

          /* Tombol EDIT */
          document.getElementById("btnEdit").onclick = () => {

            // UI-level protection: jika role admin, tolak edit
            if (d.role === "admin") {
              Swal.fire({
                icon: "error",
                title: "Tidak Bisa Edit Admin",
                text: "User dengan role admin tidak boleh diedit."
              });
              return;
            }

            Swal.close();
            setTimeout(() => {

              Swal.fire({
                title: "Edit Member",
                html: `
              <input id="eNama" class="swal2-input" value="${d.nama}">
              <input id="eHp" class="swal2-input" value="${d.hp}">
              <input id="ePass" class="swal2-input" value="${d.pass}">
              <select id="eRole" class="swal2-input">
                <option value="driver" ${d.role=="driver"?"selected":""}>Driver</option>
                <option value="leader" ${d.role=="leader"?"selected":""}>Leader</option>
                <option value="admin" ${d.role=="admin"?"selected":""}>Admin</option>
              </select>
            `,
                showCancelButton: true,
                confirmButtonText: "Simpan",
                preConfirm: () => {
                  return {
                    nama: eNama.value.trim(),
                    hp: eHp.value.trim(),
                    pass: ePass.value.trim(),
                    role: eRole.value.trim()
                  }
                }
              }).then(x => {
                if (x.isConfirmed) {

                  // UI-level protection: mencegah ubah role target dari admin ke non-admin
                  if (d.role === "admin" && x.value.role !== "admin") {
                    Swal.fire({
                      icon: "error",
                      title: "Role Tidak Boleh Diubah",
                      text: "Role admin tidak boleh diturunkan."
                    });
                    return;
                  }

                  const f = document.createElement("form");
                  f.method = "POST";

                  let arr = {
                    edit_id: d.id,
                    edit_nama: x.value.nama,
                    edit_no_hp: x.value.hp,
                    edit_password: x.value.pass,
                    edit_role: x.value.role,
                    update: 1
                  };

                  for (let k in arr) {
                    let i = document.createElement("input");
                    i.type = "hidden";
                    i.name = k;
                    i.value = arr[k];
                    f.appendChild(i);
                  }

                  document.body.appendChild(f);
                  f.submit();
                }
              });

            }, 150);
          };

          /* Tombol HAPUS */
          document.getElementById("btnHapus").onclick = () => {

            // UI-level protection: tolak hapus admin
            if (d.role === "admin") {
              Swal.fire({
                icon: "error",
                title: "Tidak Bisa Hapus Admin",
                text: "User admin tidak boleh dihapus."
              });
              return;
            }

            Swal.close();
            setTimeout(() => {

              Swal.fire({
                title: "Hapus member ini?",
                text: "Data akan dihapus permanen.",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Ya, hapus"
              }).then(xx => {
                if (xx.isConfirmed) {

                  const f = document.createElement("form");
                  f.method = "POST";

                  let i = document.createElement("input");
                  i.type = "hidden";
                  i.name = "hapus_id";
                  i.value = d.id;

                  f.appendChild(i);
                  document.body.appendChild(f);
                  f.submit();
                }
              });

            }, 150);
          };

          /* Tombol BATAL */
          document.getElementById("btnBatal").onclick = () => {
            Swal.close();
          };

        }, 200);

      };
    });
  </script>

  <!-- SweetAlert notifications (ditampilkan setelah halaman load) -->
  <script>
    <?php if (isset($_GET['add']) && $_GET['add'] == 'success'): ?>
      Swal.fire({
        icon: 'success',
        title: 'Berhasil!',
        text: 'Member baru berhasil ditambahkan'
      });
    <?php endif; ?>

    <?php if (isset($_GET['add']) && $_GET['add'] == 'fail'): ?>
      Swal.fire({
        icon: 'error',
        title: 'Gagal!',
        text: 'Terjadi kesalahan saat menyimpan data'
      });
    <?php endif; ?>

    <?php if (isset($_GET['edit']) && $_GET['edit'] == 'success'): ?>
      Swal.fire({
        icon: 'success',
        title: 'Perubahan Disimpan!',
        text: 'Data member berhasil diperbarui'
      });
    <?php endif; ?>

    <?php if (isset($_GET['edit']) && $_GET['edit'] == 'fail'): ?>
      Swal.fire({
        icon: 'error',
        title: 'Gagal!',
        text: 'Terjadi kesalahan saat memperbarui data'
      });
    <?php endif; ?>

    <?php if (isset($_GET['edit']) && $_GET['edit'] == 'denied'): ?>
      Swal.fire({
        icon: 'error',
        title: 'Akses Ditolak',
        text: 'User admin tidak boleh diedit!'
      });
    <?php endif; ?>

    <?php if (isset($_GET['edit']) && $_GET['edit'] == 'role_denied'): ?>
      Swal.fire({
        icon: 'error',
        title: 'Role Tidak Boleh Diubah',
        text: 'Role admin tidak boleh diturunkan ke driver atau leader.'
      });
    <?php endif; ?>

    <?php if (isset($_GET['hapus']) && $_GET['hapus'] == 'success'): ?>
      Swal.fire({
        icon: 'success',
        title: 'Berhasil Dihapus!',
        text: 'Data member telah dihapus'
      });
    <?php endif; ?>

    <?php if (isset($_GET['hapus']) && $_GET['hapus'] == 'fail'): ?>
      Swal.fire({
        icon: 'error',
        title: 'Gagal!',
        text: 'Terjadi kesalahan saat menghapus data'
      });
    <?php endif; ?>

    <?php if (isset($_GET['hapus']) && $_GET['hapus'] == 'denied'): ?>
      Swal.fire({
        icon: 'error',
        title: 'Akses Ditolak',
        text: 'User admin tidak boleh dihapus!'
      });
    <?php endif; ?>

    // ===============================
    // SHOW PASSWORD ON CLICK (Driver & Leader)
    // ===============================
    document.querySelectorAll(".pw").forEach(p => {

      // Kalau admin → tidak bisa klik
      if (p.dataset.role === "admin") {
        p.style.cursor = "not-allowed";
        return;
      }

      p.style.cursor = "pointer";

      p.onclick = () => {
        let pw = p.dataset.pw;
        let nama = p.dataset.nama;

        Swal.fire({
          title: `Password ${nama}`,
          html: `
                <div style="
                    padding: 12px;
                    background: rgba(255,255,255,0.15);
                    border-radius: 8px;
                    color: #fff;
                    font-size: 18px;">
                    <b>${pw}</b>
                </div>
                <br>
                <small style="color:#ccc;">Klik OK untuk menutup</small>
            `,
          confirmButtonText: "OK",
          width: 350,
          background: "rgba(20,20,20,0.5)",
        });
      };
    });
  </script>

</body>

</html>