<?php
include 'koneksi.php';
include 'auth.php'; // Pastikan user sudah login dan berhak

// Ambil data JSON dari request body
$data = json_decode(file_get_contents('php://input'), true);

if (!$data || !isset($data['id'], $data['tanggal'], $data['total_orderan'], $data['total_driver'])) {
    echo json_encode(['success' => false, 'message' => 'Data tidak lengkap']);
    exit;
}

$id = intval($data['id']);
$tanggal = $data['tanggal'];
$total_orderan = intval($data['total_orderan']);
$driver = trim($data['total_driver']);

// Validasi sederhana
if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $tanggal)) {
    echo json_encode(['success' => false, 'message' => 'Format tanggal tidak valid']);
    exit;
}

if ($total_orderan < 0) {
    echo json_encode(['success' => false, 'message' => 'Total orderan tidak valid']);
    exit;
}

if (empty($driver)) {
    echo json_encode(['success' => false, 'message' => 'Nama driver tidak boleh kosong']);
    exit;
}

// Update data di database
$stmt = $koneksi->prepare("UPDATE orders SET tanggal = ?, total_orderan = ?, total_driver = ? WHERE id = ?");
$stmt->bind_param("sisi", $tanggal, $total_orderan, $driver, $id);

if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Gagal mengupdate data']);
}
$stmt->close();
$koneksi->close();
?>
