<?php
include 'auth.php';  // Memanggil auth.php untuk mengecek login
?>
<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link rel="stylesheet" href="css/navbar.css">
  <link rel="stylesheet" href="css/formstay.css">
  <title>Form Kirim ke WhatsApp</title>
</head>
<style>
      .flex-btns {
      display: flex;
      justify-content: space-between;
      gap: 10px;
      padding-left: 10px;
      padding-right: 10px;
      margin-top: 10px;
      flex-wrap: wrap;
    }

    .flex-btns button:hover {
      background-color: #f5d216;
    }

    .flex-btns button {
      cursor: pointer;
      font-size: 18px;
      transition: background-color 0.2s ease;
      border: 1px solid #fed054;
      border-radius: 8px;
      height: 50px;
      font-size: 26px;
      flex: 1;
      min-width: 50px;
      padding: 10px;
      text-align: center;
      box-sizing: border-box;
    }
</style>
<body>

  <div class="container">
    <h2>Form Stay</h2>

    <form onsubmit="return kirimWA()">


      <label>Sift Order :</label>
      <div class="sift-group">
        <div class="sift-btn" onclick="pilihSift('1')">1</div>
        <div class="sift-btn" onclick="pilihSift('2')">2</div>
        <div class="sift-btn" onclick="pilihSift('Non')">Non</div>
      </div>
      <input type="hidden" id="sift" required>

      <label for="orderan">Total Order :</label>
      <div class="orderan-group">
        <button type="button" onclick="ubahOrderan(-1)">−</button>
        <input type="tel" id="orderan" placeholder="Contoh : 7" required readonly oninput="simpanOrderan()">
        <button type="button" onclick="ubahOrderan(1)">+</button>
      </div>


      <label>Stay :</label>
      <div class="lokasi-container">
        <input type="text" id="lokasi1" placeholder="Lokasi 1" required autocomplete="off">
        <input type="text" id="lokasi2" placeholder="Lokasi 2" autocomplete="off">
        <input type="text" id="lokasi3" placeholder="Lokasi 3" autocomplete="off">
      </div>

      <button type="submit">Stay Sekarang</button>
      <button type="button" id="resetSiftBtn" style="display:none; background-color:#ff5c5c; margin-top: -4px;"
        onclick="resetSift()">Ganti Sift</button>

    </form>
    <button type="button" onclick="lihatHistory()" style="margin-top: 10px;">
      Lihat History Stay
    </button>
  </div>
  </div>
    <?php include 'navbar.php'; ?>

  <script>
    let siftTerkunci = false;

    window.onload = () => {
      const savedSift = localStorage.getItem("sift");
      if (savedSift) {
        document.getElementById("sift").value = savedSift;
        const buttons = document.querySelectorAll(".sift-btn");
        buttons.forEach(btn => {
          if (btn.textContent === savedSift) {
            btn.classList.add("active");
            btn.style.pointerEvents = "none";
            btn.style.opacity = "0.6";
          } else {
            btn.style.display = "none";
          }
        });
        document.getElementById("resetSiftBtn").style.display = "block";
        siftTerkunci = true;
      }

      const savedOrderan = localStorage.getItem("orderan");
      if (savedOrderan) {
        document.getElementById("orderan").value = savedOrderan;
      }

      // Tampilkan riwayat stay
      tampilkanHistory();
    };


    function pilihSift(value) {
      if (siftTerkunci) return;

      document.getElementById("sift").value = value;
      localStorage.setItem("sift", value); // simpan ke localStorage

      const buttons = document.querySelectorAll(".sift-btn");
      buttons.forEach(btn => {
        btn.classList.remove("active");
        btn.style.pointerEvents = "none";
        btn.style.opacity = "0.6";
        if (btn.textContent === value) {
          btn.classList.add("active");
        } else {
          btn.style.display = "none";
        }
      });

      siftTerkunci = true;
      document.getElementById("resetSiftBtn").style.display = "block";
    }

    function resetSift() {
      const buttons = document.querySelectorAll(".sift-btn");
      buttons.forEach(btn => {
        btn.style.pointerEvents = "auto";
        btn.style.opacity = "1";
        btn.style.display = "block";
        btn.classList.remove("active");
      });

      document.getElementById("sift").value = "";
      localStorage.removeItem("sift"); // hapus dari localStorage
      siftTerkunci = false;
      document.getElementById("resetSiftBtn").style.display = "none";
    }

    function kirimWA() {
      const sift = document.getElementById("sift").value.trim();
      const orderan = document.getElementById("orderan").value.trim();
      const lokasi1 = document.getElementById("lokasi1").value.trim();
      const lokasi2 = document.getElementById("lokasi2").value.trim();
      const lokasi3 = document.getElementById("lokasi3").value.trim();

      if (!sift || !orderan || !lokasi1) {
        Swal.fire({
          icon: 'warning',
          title: 'Data belum lengkap',
          text: 'Harap isi semua field sebelum melanjutkan.'
        });
        return false;
      }

      Swal.fire({
        title: 'Lanjut Stay?',
        text: 'Data akan dikirim ke WhatsApp.',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Ya, kirim!',
        cancelButtonText: 'Tidak',
      }).then((result) => {
        if (result.isConfirmed) {
          const noWa = "+6281289446661";
          const text = `Stay: *${lokasi1}*, *${lokasi2}*, *${lokasi3}* (S${sift})\nTotal: *${orderan}*`;
          const url = "whatsapp://send?phone=" + noWa + "&text=" + encodeURIComponent(text);
          window.open(url, "_blank");

          tambahKeHistory(lokasi1, lokasi2, lokasi3, orderan); // Tambah ke riwayat
        }
      });

      return false; // Mencegah form reload
    }


    function simpanOrderan() {
      const orderan = document.getElementById("orderan").value.trim();
      localStorage.setItem("orderan", orderan);
    }

    function ubahOrderan(delta) {
      let input = document.getElementById("orderan");
      let value = parseInt(input.value) || 0;
      value += delta;
      if (value < 0) value = 0;
      input.value = value;
      simpanOrderan();
    }

    function tampilkanHistory() {
      const historyList = document.getElementById("historyList");
      historyList.innerHTML = "";
      const history = JSON.parse(localStorage.getItem("stayHistory")) || [];

      history.forEach(item => {
        const li = document.createElement("li");
        li.textContent = `${item.lokasi1} - ${item.lokasi2} - ${item.lokasi3} (Orderan ke: ${item.orderan})`;
        historyList.appendChild(li);
      });
    }

    function tambahKeHistory(lokasi1, lokasi2, lokasi3, orderan) {
      const history = JSON.parse(localStorage.getItem("stayHistory")) || [];

      const now = new Date();
      const jam = now.getHours().toString().padStart(2, "0") + ":" + now.getMinutes().toString().padStart(2, "0");

      history.unshift({ lokasi1, lokasi2, lokasi3, orderan, jam }); // Tambah jam
      localStorage.setItem("stayHistory", JSON.stringify(history));
    }

    function hapusHistory() {
      Swal.fire({
        title: 'Hapus semua riwayat?',
        text: "Data tidak bisa dikembalikan!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Ya, hapus!',
        cancelButtonText: 'Batal'
      }).then((result) => {
        if (result.isConfirmed) {
          localStorage.removeItem("stayHistory");
          tampilkanHistory();
          Swal.fire('Dihapus!', 'Riwayat stay telah dihapus.', 'success');
        }
      });
    }

    function lihatHistory() {
      const history = JSON.parse(localStorage.getItem("stayHistory")) || [];

      if (history.length === 0) {
        Swal.fire("Kosong", "Belum ada riwayat stay.", "info");
        return;
      }

      let html = "<ul style='text-align:left; padding-left: 20px;'>";
      history.forEach(item => {
        html += `<li>${item.lokasi1} - ${item.lokasi2} - ${item.lokasi3} (${item.orderan}) - (${item.jam})</li>`;
      });
      html += "</ul>";

      Swal.fire({
        title: "Riwayat Stay",
        html: html,
        width: 600,
        scrollbarPadding: false,
        showCancelButton: true,
        cancelButtonText: "Tutup",
        confirmButtonText: "🗑 Hapus Semua",
        confirmButtonColor: "#dc3545"
      }).then(result => {
        if (result.isConfirmed) {
          localStorage.removeItem("stayHistory");
          Swal.fire("Dihapus", "Semua riwayat telah dihapus.", "success");
        }
      });
    }


  </script>




</body>

</html>