<?php
include 'koneksi.php';
include 'auth.php'; // Cek login
date_default_timezone_set("Asia/Jakarta");

if (!isset($_SESSION['user'])) {
    header('location:login.php');
    exit;
}

// Ambil nama user dari session
$nama = $_SESSION['user']['nama'];
$role = $_SESSION['user']['role'] ?? '';
$tanggal_sekarang = date('Y-m-d');
$now = new DateTime();
$nama_asli = '';

// Ambil foto dan nama_asli dari tabel user (prepared statement)
$stmt_user = $koneksi->prepare("SELECT nama_asli, foto FROM user WHERE nama = ? LIMIT 1");
$stmt_user->bind_param("s", $nama);
$stmt_user->execute();
$result_user = $stmt_user->get_result();
if ($result_user && $row_user = $result_user->fetch_assoc()) {
    $nama_asli = $row_user['nama_asli'] ?? '';
    $foto_db = $row_user['foto'] ?? '';
} else {
    $foto_db = '';
}
$stmt_user->close();

// Tentukan path foto: sesuaikan folder upload jika berbeda.
// Jika kolom foto sudah berisi path penuh, langsung gunakan itu.
$foto_path = '';
if (!empty($foto_db)) {
    // contoh asumsi: foto disimpan di folder uploads/
    $foto_path_candidate = 'uploads/' . $foto_db;
    if (file_exists($foto_path_candidate)) {
        $foto_path = $foto_path_candidate;
    } else {
        // jika file tidak ditemukan, biarkan kosong supaya fallback icon muncul
        $foto_path = '';
    }
}

// Ambil data absensi hari ini (jika ada)
$absen_result = $koneksi->prepare("SELECT sift, stay, off FROM absen WHERE nama = ? AND tanggal = ?");
$absen_result->bind_param("ss", $nama_asli, $tanggal_sekarang);
$absen_result->execute();
$absen_data = $absen_result->get_result()->fetch_assoc();
$absen_result->close();

// Ambil nilai status dan sift
$sift_value = $absen_data['sift'] ?? '-';
$status_value = '';
if (!empty($absen_data['off'])) {
    $status_value = 'OFF';
} elseif (!empty($absen_data['stay'])) {
    $status_value = 'STAY';
} else {
    $status_value = '-';
}

// Ambil semua nama dari tabel user (tidak dipakai UI utama, tetap seperti kode awal)
$user_query = $koneksi->query("SELECT nama_asli FROM user");
$nama_list = [];
while ($row = $user_query->fetch_assoc()) {
    $nama_list[] = $row['nama_asli'];
}

// Ubah semua data STAY yang tanggalnya sudah lewat dan belum OFF
$now_date = date('Y-m-d');
$now_time = date('H:i:s');

$sql_update = "
    UPDATE absen 
    SET off = IF(off IS NULL OR off = '', ?, off)
    WHERE tanggal < ? AND stay IS NOT NULL AND (off IS NULL OR off = '')
";
$stmt_update = $koneksi->prepare($sql_update);
$stmt_update->bind_param("ss", $now_time, $now_date);
$stmt_update->execute();
$stmt_update->close();

?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Home | Driver</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Bootstrap (tetap ada) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="css/navbar.css">

    <!-- CSS khusus halaman -->
    <style>
        :root {
            --bg-navy: #071733;
            --card-blue: #1f4f82;
            --card-inner: #163e6b;
            --silver-grad: linear-gradient(#f2f2f2, #d9d9d9);
            --yellow: #ffd800;
            --muted: #eef3f7;
        }

        html,
        body {
            margin: 0;
            font-family: 'Segoe UI', Roboto, Arial, sans-serif;
            background: var(--bg-navy);
            color: #fff;
        }

        /* Header profil atas seperti contoh */
        .top-header {
            display: flex;
            align-items: center;
            gap: 14px;
            padding: 14px 18px;
            margin: 18px;

            /* iOS frosted glass + gold tint */
            background: rgba(173, 196, 255, 0.2);
            backdrop-filter: blur(18px) saturate(160%);
            -webkit-backdrop-filter: blur(18px) saturate(160%);

            /* rounded besar ala iOS */
            border-radius: 15px;

            /* border emas lembut */
            border: 1.4px solid rgba(255, 255, 255, 0.45);

            /* soft inner & outer glow */
            box-shadow:
                inset 0 1px 3px rgba(255, 255, 255, 0.35),
                inset 0 -1px 3px rgba(120, 80, 0, 0.20),
                0 8px 20px rgba(0, 0, 0, 0.22),
                0 0 12px rgba(255, 200, 60, 0.22);
            /* gold aura */

            /* teks sedikit lebih keemasan */
            color: #ffe9a3;

            transition: none;
        }

        .profile-photo {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            overflow: hidden;
            border: 2px solid rgba(255, 255, 255, 0.08);
            background: #707070ff;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .profile-photo img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: block;
        }

        .greeting {
            flex: 1;
            text-align: left;
        }

        .greeting h1 {
            margin: 0;
            font-size: 20px;
            font-weight: 600;
            color: #fff;
            letter-spacing: 0.5px;
        }

        .greeting p {
            margin: 0;
            font-size: 12px;
            color: rgba(255, 255, 255, 0.8);
        }

        /* Main card (absensi + menu) */
        .main-card {
            width: 320px;
            margin: 16px auto 10px;
            background: #233a6a;
            border-radius: 14px;
            padding: 18px;
            box-shadow: 0 10px 0 rgba(0, 0, 0, 0.35);
            border: 4px solid rgba(255, 255, 255, 0.06);
        }

        /* Absensi box (mirip gambar) */
        .absen-card {
            background: transparent;
            border: 3px solid rgba(255, 255, 255, 0.36);
            border-radius: 20px;
            padding: 12px;
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .absen-top {
            display: flex;
            gap: 10px;
        }

        .date-box,
        .shift-box {
            flex: 1;
            background: rgba(255, 255, 255, 0.20);
            backdrop-filter: blur(14px);
            border-radius: 15px;
            padding: 14px;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.35);
            box-shadow:
                inset 0 1px 3px rgba(255, 255, 255, 0.5),
                inset 0 -2px 4px rgba(0, 0, 0, 0.15);
            color: #fff;
            font-size: 19px;
            font-weight: 600;
            transition: none;
        }

        .date-box .date {
            font-size: 18px;
            color: var(--yellow);
            font-weight: 700;
        }

        .shift-box .shift {
            font-size: 20px;
            color: var(--yellow);
            font-weight: 700;
        }

        .stay-box {
            flex: 1;
            background: rgba(0, 0, 0, 0.7);
            border-radius: 8px;
            padding: 8px;
            text-align: center;
            border: 3px solid rgba(255, 255, 255, 0.12);
        }

        .stay-box .stay-text {
            font-size: 44px;
            font-weight: 800;
            color: var(--yellow);
            line-height: 1;
        }

        .absen-action {
            margin-top: 6px;
            display: flex;
            justify-content: center;
        }

        .absen-action button {
            width: 100%;
            background: linear-gradient(#ffe680, #ffcc00);
            /* kuning glossy */
            color: #04003aff;
            /* gelap elegan */
            border: none;
            padding: 14px;
            font-size: 18px;
            font-weight: 700;
            border-radius: 14px;

            box-shadow:
                0 6px 0 #d1a700,
                /* shadow tebal bawah */
                0 4px 10px rgba(0, 0, 0, 0.18),
                /* outer shadow */
                inset 0 3px 4px rgba(255, 255, 255, 0.45);
            /* inner glossy */

            transition:
                transform 220ms cubic-bezier(.15, .85, .35, 1),
                box-shadow 220ms cubic-bezier(.15, .85, .35, 1);
        }

        /* Hover */
        .absen-action button:hover {
            transform: translateY(-3px);
            box-shadow:
                0 9px 0 #d1a700,
                0 6px 14px rgba(0, 0, 0, 0.22),
                inset 0 3px 5px rgba(255, 255, 255, 0.5);
        }

        /* Active (ditekan) */
        .absen-action button:active {
            transform: translateY(2px);
            box-shadow:
                0 3px 0 #d1a700,
                0 2px 6px rgba(0, 0, 0, 0.2),
                inset 0 5px 6px rgba(0, 0, 0, 0.25);
        }


        /* Grid menu */
        .menu-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            margin-top: 18px;
            justify-items: center;
        }

        .menu-btn {
            background: linear-gradient(#ffe680, #ffcc00);
            border-radius: 14px;
            width: 80px;
            height: 70px;
            padding: 5px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: #04003aff;
            font-weight: 700;
            border: none;
            box-shadow:
                0 6px 0 #d1a700,
                0 4px 10px rgba(0, 0, 0, 0.18),
                inset 0 2px 4px rgba(255, 255, 255, 0.4);

            transition:
                transform 220ms cubic-bezier(.15, .85, .35, 1),
                box-shadow 220ms cubic-bezier(.15, .85, .35, 1);
        }

        .menu-btn:hover {
            transform: translateY(-3px);
            box-shadow:
                0 9px 0 #d1a700,
                0 6px 14px rgba(0, 0, 0, 0.24),
                inset 0 2px 5px rgba(255, 255, 255, 0.45);
        }

        .menu-btn:active {
            transform: translateY(2px);
            box-shadow:
                0 3px 0 #d1a700,
                0 2px 6px rgba(0, 0, 0, 0.2),
                inset 0 4px 6px rgba(0, 0, 0, 0.2);
        }

        .menu-btn i {
            font-size: 26px;
            margin-bottom: 4px;
            color: #04003aff;
            filter: drop-shadow(0 1px 1px rgba(0, 0, 0, 0.3));
        }

        .menu-btn div {
            font-size: 12px;
            margin-top: 1px;
        }


        .menu-btn i {
            font-size: 22px;
            display: block;
            margin-bottom: 6px;
        }

        .menu-btn:active {
            transform: translateY(2px);
        }

        /* Large empty box bawah seperti contoh */
        .note-box {
            margin: 18px auto;
            /* Tengah + jarak atas */
            background: #f0f0f0ff;
            border-radius: 10px;
            height: 80px;
            width: 100%;
            /* full area */
            max-width: 330px;
            /* batas kanan-kiri */
        }

        /* Responsive small */
        @media (max-width:420px) {
            .main-card {
                width: 92%;
                padding: 14px;
            }

            .stay-box .stay-text {
                font-size: 36px;
            }
        }

        /* hidden inputs pointer */
        input[readonly] {
            background: transparent;
            color: #fff;
            border: 0;
            outline: 0;
        }

        /* small helper to hide native input borders */
        .hidden-native {
            border: 0;
            background: transparent;
            padding: 0;
            margin: 0;
        }

        .logo-box {
            width: 100%;
            display: flex;
            justify-content: left;
            /* horizontal tengah */
            align-items: center;
            /* vertical tengah */
            margin: 20px 20px 5px 10px;
            /* jarak atas-bawah (kecil) */
        }

        .header-mini {
            background: #071733;
            /* navy dark seperti contoh */
            padding: 10px 14px;
            display: flex;
            border: 3px solid rgba(255, 255, 255, 0.24);
            align-items: center;
            justify-content: space-between;
            /* kiri & kanan */
            border-radius: 10px;
            margin: 10px 15px 0 15px;
            /* jarak kiri kanan */
            box-shadow: 0 1px 0 rgba(226, 223, 223, 0.3);
        }

        .mini-left {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .mini-logo {
            width: 130px;
            height: auto;
            object-fit: contain;
        }

        .mini-title {
            color: #d1a700;
            font-size: 16px;
            font-weight: 600;
        }

        .wa-btn {
            background: #233a6a;
            /* biru gelap */
            border: none;
            padding: 8px 14px;
            color: #ffd800;
            /* kuning gold */
            font-size: 14px;
            border-radius: 8px;
            font-weight: 500;

            /* soft 3D */
            box-shadow:
                inset 0 -3px 0 rgba(0, 0, 0, 0.25),
                0 3px 6px rgba(0, 0, 0, 0.25);

            /* Transition lembut */
            transition:
                background 200ms ease,
                transform 200ms cubic-bezier(.2, .8, .3, 1),
                box-shadow 200ms ease;
        }

        /* Hover efek lembut premium */
        .wa-btn:hover {
            background: #2a4a8a;
            /* biru sedikit lebih terang */
            transform: translateY(-2px);
            /* naik sedikit */
            box-shadow:
                inset 0 -3px 0 rgba(0, 0, 0, 0.2),
                0 6px 12px rgba(0, 0, 0, 0.28);
            /* shadow lebih “halus” */
        }

        /* Active (klik) */
        .wa-btn:active {
            transform: translateY(1px);
            box-shadow:
                inset 0 -3px 0 rgba(0, 0, 0, 0.3),
                0 2px 4px rgba(0, 0, 0, 0.22);
        }


        .wa-btn:active {
            transform: translateY(2px);
        }

        /* ===========================================
   KOTAK PEMBUNGKUS (iOS Gold Glass)
   =========================================== */
        .mitra-box {
            margin: 18px 16px;
            padding: 16px;
            display: flex;
            gap: 10px;
            /* jarak antar tombol */
            background: #233a6a;
            backdrop-filter: blur(14px) saturate(160%);
            -webkit-backdrop-filter: blur(14px) saturate(160%);
            justify-content: space-between;

            border-radius: 15px;
            border: 1.5px solid rgba(255, 210, 90, 0.45);

            box-shadow:
                inset 0 1px 3px rgba(255, 255, 255, 0.35),
                inset 0 -2px 3px rgba(120, 80, 0, 0.20),
                0 6px 16px rgba(0, 0, 0, 0.25),
                0 0 10px rgba(255, 200, 60, 0.18);
        }


        /* ===========================================
   SUSUNAN 3 TOMBOL
   =========================================== */
        .mitra-menu {
            display: flex;
            justify-content: space-between;
            gap: 5px;
        }


        /* ===========================================
   TOMBOL MINI 3D PREMIUM
   =========================================== */
        .mitra-btn {
            background: linear-gradient(#ffe680, #ffcc00);
            border-radius: 14px;
            width: 70px;
            height: 40px;
            padding: 6px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            color: #3a3300;
            font-weight: 700;
            font-size: 11px;
            border: none;
            box-shadow:
                0 5px 0 #d1a700,
                0 4px 10px rgba(0, 0, 0, 0.18),
                inset 0 2px 4px rgba(255, 255, 255, 0.45);
            transition:
                transform 200ms cubic-bezier(.15, .85, .35, 1),
                box-shadow 200ms ease;
        }

        /* Hover */
        .mitra-btn:hover {
            transform: translateY(-3px);
            box-shadow:
                0 7px 0 #d1a700,
                0 6px 14px rgba(0, 0, 0, 0.24),
                inset 0 2px 5px rgba(255, 255, 255, 0.5);
        }

        /* Active */
        .mitra-btn:active {
            transform: translateY(2px);
            box-shadow:
                0 3px 0 #d1a700,
                0 3px 6px rgba(0, 0, 0, 0.22),
                inset 0 4px 6px rgba(0, 0, 0, 0.2);
        }

        /* Icon untuk tombol */
        .mitra-btn i {
            font-size: 18px;
            margin-bottom: 4px;
            color: #3a3300;
            filter: drop-shadow(0 1px 1px rgba(0, 0, 0, 0.25));
        }

        /* SweetAlert2 - Navy Glassmorphism + Margin */
        .swal2-popup {
            background: rgba(30, 45, 80, 0.35) !important;
            backdrop-filter: blur(14px) !important;
            -webkit-backdrop-filter: blur(14px) !important;
            /* Margin agar ada jarak dari sisi layar */
            margin-left: 500px !important;
            margin-right: 500px !important;
            border: 2px solid rgba(90, 120, 180, 0.4);
            border-radius: 16px;
            color: #ffffff !important;
            font-size: 16px;
            box-shadow: 0 100px 28px rgba(0, 0, 0, 0.35);
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        /* Judul popup */
        .swal2-title {
            font-size: 20px;
            color: #ffffffff;
            text-align: center;
        }

        /* Input fields */
        .swal2-input {
            width: 100%;
            max-width: 250px;
            margin: 8px auto;
            background-color: #1e2329 !important;
            color: #ffffff !important;
            border: 1px solid #444 !important;
            border-radius: 8px;
            padding: 10px 12px;
            box-sizing: border-box;
        }

        /* Base styling untuk semua tombol SweetAlert */
        .swal2-styled {
            padding: 14px 26px !important;
            font-size: 17px !important;
            font-weight: 700 !important;
            border-radius: 14px !important;
            backdrop-filter: blur(10px) !important;
            -webkit-backdrop-filter: blur(10px) !important;
            box-shadow:
                0 10px 18px rgba(0, 0, 0, 0.35),
                inset 0 5px 8px rgba(255, 255, 255, 0.22),
                inset 0 -5px 8px rgba(0, 0, 0, 0.30);
            transition: 0.22s ease !important;
        }

        /* Hover umum */
        .swal2-styled:hover {
            transform: translateY(-3px);
        }

        /* Active umum */
        .swal2-styled:active {
            transform: translateY(3px);
        }

        /* --------------------------- */
        /*  STAY (Hijau Glass)         */
        /* --------------------------- */
        .swal2-confirm {
            background: rgba(40, 150, 80, 0.45) !important;
            /* hijau transparan */
            border: 2px solid rgba(120, 230, 160, 0.5) !important;
            color: #fff !important;
            box-shadow:
                0 10px 18px rgba(0, 0, 0, 0.35),
                inset 0 6px 10px rgba(255, 255, 255, 0.20),
                inset 0 -6px 10px rgba(0, 0, 0, 0.35);
        }

        .swal2-confirm:hover {
            background: rgba(55, 180, 110, 0.55) !important;
        }

        /* --------------------------- */
        /*  OFF (Merah Glass)          */
        /* --------------------------- */
        .swal2-deny {
            background: rgba(180, 40, 60, 0.45) !important;
            /* merah transparan */
            border: 2px solid rgba(255, 150, 150, 0.5) !important;
            color: #fff !important;
        }

        .swal2-deny:hover {
            background: rgba(210, 55, 80, 0.55) !important;
        }

        /* --------------------------- */
        /*  Batal (Hitam Glass)        */
        /* --------------------------- */
        .swal2-cancel {
            background: rgba(20, 20, 20, 0.45) !important;
            /* hitam transparan */
            border: 2px solid rgba(180, 180, 180, 0.4) !important;
            color: #fff !important;
        }

        .swal2-cancel:hover {
            background: rgba(40, 40, 40, 0.55) !important;
        }


        /* Tombol shift 3D - Glass Navy Cembung */
        .swal-shift-btn {
            padding: 16px 20px;
            min-width: 80px;
            font-size: 18px;
            font-weight: 700;
            color: #ffffff;

            /* Tambahkan jarak antar tombol */
            margin: 0 6px;

            /* Glass navy */
            background: rgba(40, 60, 110, 0.45);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);

            border-radius: 18px;
            border: 2px solid rgba(180, 200, 255, 0.45);

            cursor: pointer;
            transition: 0.22s ease;

            /* --- Efek 3D tonjol keluar --- */
            box-shadow:
                0 12px 18px rgba(0, 0, 0, 0.45),
                inset 0 6px 10px rgba(255, 255, 255, 0.25),
                inset 0 -6px 10px rgba(0, 0, 0, 0.35),
                0 0 14px rgba(90, 120, 200, 0.5);
        }

        /* Hover: makin menonjol */
        .swal-shift-btn:hover {
            transform: translateY(-4px);
            box-shadow:
                0 16px 22px rgba(0, 0, 0, 0.55),
                inset 0 7px 11px rgba(255, 255, 255, 0.28),
                inset 0 -7px 11px rgba(0, 0, 0, 0.4),
                0 0 16px rgba(110, 140, 230, 0.6);
        }

        /* Active: ditekan */
        .swal-shift-btn:active {
            transform: translateY(3px);
            box-shadow:
                0 7px 10px rgba(0, 0, 0, 0.45),
                inset 0 3px 6px rgba(255, 255, 255, 0.18),
                inset 0 -4px 7px rgba(0, 0, 0, 0.35),
                0 0 12px rgba(90, 120, 200, 0.45);
        }

        /* Hilangkan garis animasi */
        .swal2-success-ring,
        .swal2-success-fix {
            background: none !important;
            display: none !important;
        }

        /* Hapus inner circle */
        .swal2-success-circular-line-left,
        .swal2-success-circular-line-right {
            display: none !important;
        }
    </style>
</head>

<body>

    <div class="header-mini">
        <div class="mini-left">
            <img src="img/tior.png" class="mini-logo">
        </div>

        <button class="wa-btn" onclick="pindahMenuDriver()">
            Menu Admin
        </button>


    </div>


    <!-- HEADER with profile photo & greeting -->
    <div class="top-header" style="margin-top:18px; margin-left:16px; margin-right:16px;">
        <div class="profile-photo">
            <?php if (!empty($foto_path)): ?>
                <img src="<?= htmlspecialchars($foto_path) ?>" alt="Foto <?= htmlspecialchars($nama) ?>">
            <?php else: ?>
                <!-- fallback: FontAwesome user icon -->
                <i class="fa-solid fa-user" style="color:#163e6b; font-size:30px;"></i>
            <?php endif; ?>
        </div>
        <div class="greeting">
            <h1>Hallo, <?= htmlspecialchars($nama) ?></h1>
            <div class="date"><?= date('d/m/Y') ?></div>
        </div>
    </div>

    <!-- MAIN CARD -->
    <div class="main-card">
        <!-- Form absen -->
        <form method="post" id="absenForm">
            <input type="hidden" id="nama" name="nama" value="<?= htmlspecialchars($nama_asli) ?>">
            <input type="hidden" name="tanggal" id="tanggal" value="<?= date('Y-m-d') ?>">

            <div class="absen-card">
                <div style="display:flex; gap:10px;">
                    <!-- Left column with date & shift -->
                    <div style="flex:0.9; display:flex; flex-direction:column; gap:10px;">
                        <div class="shift-box">
                            <div class="shift" id="siftDisplay"><?= htmlspecialchars($sift_value) ?></div>
                        </div>
                    </div>

                    <!-- Right column big STAY box -->
                    <div style="flex:0.9; display:flex; flex-direction:column; gap:10px;">
                        <div class="shift-box">
                            <div class="shift" id="statusDisplay">
                                <?= htmlspecialchars($status_value) ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="absen-action">
                    <button type="button" onclick="handleAbsen()">START</button>
                </div>
                <!-- hidden text inputs to keep previous JS logic (readonly) -->
                <div style="display:flex; gap:8px;">
                    <div style="flex:1;">
                        <div style="display:none;">
                            <i class="fas fa-user"></i>
                            <input type="text" id="nama_panggilan" value="<?= htmlspecialchars($nama) ?>" readonly class="hidden-native">
                        </div>
                        <input type="text" id="siftInput" name="sift" value="<?= htmlspecialchars($sift_value) ?>" readonly hidden>
                        <input type="text" id="statusInput" name="status" value="<?= htmlspecialchars($status_value) ?>" readonly hidden>
                    </div>
                </div>


            </div>
        </form>

        <!-- Menu Grid -->
        <div class="menu-grid" id="menuContainer">
            <button class="menu-btn" onclick="window.location.href='treport.php'">
                <i class="fa-solid fa-bag-shopping"></i>
                <div>Order</div>
            </button>

            <button class="menu-btn" onclick="window.location.href='formreport.php'">
                <i class="fa-solid fa-chart-column"></i>
                <div>Report</div>
            </button>

            <button class="menu-btn" onclick="window.location.href='penghasilan.php'">
                <i class="fa-solid fa-wallet"></i>
                <div>Wallet</div>
            </button>

            <button class="menu-btn" onclick="window.location.href='cek_ongkir.php'">
                <i class="fa-solid fa-truck-fast"></i>
                <div>Cek Tarif</div>
            </button>

            <button class="menu-btn" onclick="window.location.href='profil.php'">
                <i class="fa-solid fa-user-gear"></i>
                <div>Akun Saya</div>
            </button>

            <button class="menu-btn" onclick="confirmLogout()">
                <i class="fa-solid fa-person-walking-arrow-right"></i>
                <div>Logout</div>
            </button>

            <!-- filler to keep grid 3x3 layout (optional) -->
            <div style="visibility:hidden;"></div>
            <div style="visibility:hidden;"></div>
        </div>
    </div>

    <div class="mitra-box">

        <button class="mitra-btn" onclick="window.location.href='kontak.php'">
            <i class="fa-solid fa-address-book"></i>
        </button>

        <button class="mitra-btn" onclick="window.location.href=''">
            <i class="fa-solid fa-list"></i>
        </button>

        <button class="mitra-btn" onclick="window.location.href='rekening.php'">
            <i class="fa-solid fa-bank"></i>
        </button>

    </div>

    <div style="text-align:center; margin-top:30px; color: #c9c9c9ff;">
        <h6>© TIOR Delivery 2025</h6>
    </div>

    <!-- JavaScript (tetap pakai SweetAlert logic dari kamu) -->
    <script>
        const userRole = "<?= $role ?>";

        function handleAbsen() {
            // Sembunyikan tombol "Order" saat awal
            var orderBtn = document.getElementById('orderButton');
            if (orderBtn) orderBtn.style.display = 'none';

            Swal.fire({
                title: 'Pilih Status',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'ON',
                denyButtonText: 'OFF',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    // STAY -> pilih sift
                    Swal.fire({
                        title: 'Pilih Shift',
                        html: `
<div style="display:flex; gap:8px; justify-content:center;">
    <button class="swal-shift-btn" onclick="setSift('SHIFT 1')">S 1</button>
    <button class="swal-shift-btn" onclick="setSift('SHIFT 2')">S 2</button>
    <button class="swal-shift-btn" onclick="setSift('SHIFT 3')">S 3</button>
</div>

                        `,
                        showCancelButton: true,
                        cancelButtonText: 'Batal',
                        showConfirmButton: false
                    });
                } else if (result.isDenied) {
                    Swal.fire({
                        icon: 'question',
                        title: 'Konfirmasi',
                        text: 'Anda ingin lanjut OFF?',
                        showCancelButton: true,
                        confirmButtonText: 'Ya, lanjutkan',
                        cancelButtonText: 'Batal'
                    }).then((confirmResult) => {
                        if (confirmResult.isConfirmed) {
                            document.getElementById('statusInput').value = 'OFF';
                            document.getElementById('statusDisplay').innerText = 'OFF';
                            document.getElementById('siftInput').value = '';
                            if (orderBtn) orderBtn.style.display = 'none';
                            setTimeout(() => {
                                document.getElementById('absenForm').submit();
                            }, 100);
                        }
                    });
                }
            });
        }

        function setSift(value) {
            document.getElementById('siftInput').value = value;
            document.getElementById('siftDisplay').innerText = value;
            document.getElementById('statusInput').value = 'STAY';
            document.getElementById('statusDisplay').innerText = 'STAY';
            Swal.close(); // Tutup popup pilihan sift

            // Tampilkan tombol "Order"
            var orderBtn = document.getElementById('orderButton');
            if (orderBtn) orderBtn.style.display = 'inline-block';

            // Konfirmasi untuk STAY
            Swal.fire({
                icon: 'question',
                title: 'Konfirmasi',
                text: 'Anda ingin lanjut STAY?',
                showCancelButton: true,
                confirmButtonText: 'Ya, lanjutkan',
                cancelButtonText: 'Batal'
            }).then((confirmResult) => {
                if (confirmResult.isConfirmed) {
                    document.getElementById('absenForm').submit();
                } else {
                    // jika batal, reset tampilan
                    document.getElementById('siftInput').value = '';
                    document.getElementById('siftDisplay').innerText = '';
                    if (orderBtn) orderBtn.style.display = 'none';
                }
            });
        }

        function confirmLogout() {
            Swal.fire({
                title: 'Yakin ingin logout?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, Logout',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    localStorage.removeItem("userSession");
                    window.location.href = "logout.php";
                }
            });
        }

        document.addEventListener('DOMContentLoaded', function() {
            const status = document.getElementById('statusInput').value;
            const orderBtn = document.getElementById('orderButton');

            if (status !== 'STAY') {
                if (orderBtn) orderBtn.style.display = 'none';
            } else {
                if (orderBtn) orderBtn.style.display = 'inline-block';
            }
        });

        function pindahMenuDriver() {

            // Jika bukan admin, tampilkan SweetAlert + gambar
            if (userRole !== "admin") {
                Swal.fire({
                    title: "Akses Ditolak",
                    text: "Menu ini khusus untuk Admin.",
                    imageUrl: "img/lock.png", // 🔒 gambar bebas, bisa diganti
                    imageWidth: 90,
                    imageHeight: 90,
                    imageAlt: "Akses Ditolak",
                    confirmButtonText: "Mengerti",
                });
                return; // hentikan fungsi agar tidak lanjut ke admin.php
            }

            // Jika admin → tampilkan animasi pindah menu
            Swal.fire({
                title: "Beralih Ke...",
                text: "Menu Admin",
                imageUrl: "img/head.png",
                imageWidth: 80,
                imageHeight: 80,
                showConfirmButton: false,
                timer: 1200,
                timerProgressBar: true
            });

            setTimeout(() => {
                window.location.href = "admin.php";
            }, 800);
        }
    </script>

    <?php
    // ====== Proses POST (absensi) ======
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        include 'koneksi.php';

        $nama_post = $_POST['nama'];
        $tanggal_post = $_POST['tanggal'];
        $status = $_POST['status'] ?? '';
        $sift = $_POST['sift'] ?? null;
        $waktu_sekarang = new DateTime();

        // Validasi status kosong
        if (empty($status)) {
            echo "<script>
        Swal.fire({
            icon: 'error',
            title: 'Gagal',
            text: 'Status absensi tidak boleh kosong.'
        }).then(() => {
            window.history.back();
        });
        </script>";
            exit;
        }

        if ($status === 'STAY' && empty($sift)) {
            echo "<script>
        Swal.fire({
            icon: 'error',
            title: 'Gagal',
            text: 'Sift harus dipilih untuk STAY.'
        }).then(() => {
            window.history.back();
        });
        </script>";
            exit;
        }

        // Ambil data absen hari ini
        $query = $koneksi->prepare("SELECT stay, off FROM absen WHERE nama = ? AND tanggal = ?");
        $query->bind_param("ss", $nama_post, $tanggal_post);
        $query->execute();
        $query->store_result();
        $query->bind_result($waktu_stay_db, $waktu_off_db);
        $query->fetch();

        // Validasi waktu 8 jam
        if ($status === 'STAY' && $waktu_stay_db) {
            $waktu_stay = new DateTime($waktu_stay_db);
            $selisih = $waktu_sekarang->getTimestamp() - $waktu_stay->getTimestamp();
            if ($selisih < 8 * 3600) {
                echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Gagal',
                text: 'Anda sudah melakukan STAY hari ini. Silakan tunggu minimal 8 jam sebelum STAY lagi.'
            }).then(() => {
                window.history.back();
            });
            </script>";
                exit;
            }
        }

        if ($status === 'OFF' && $waktu_off_db) {
            $waktu_off = new DateTime($waktu_off_db);
            $selisih = $waktu_sekarang->getTimestamp() - $waktu_off->getTimestamp();
            if ($selisih < 8 * 3600) {
                echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Gagal',
                text: 'Anda sudah melakukan OFF hari ini. Silakan tunggu minimal 8 jam sebelum OFF lagi.'
            }).then(() => {
                window.history.back();
            });
            </script>";
                exit;
            }
        }

        $query->close();

        $waktu = $waktu_sekarang->format("H:i:s");
        $cek = $koneksi->prepare("SELECT id FROM absen WHERE nama = ? AND tanggal = ?");
        $cek->bind_param("ss", $nama_post, $tanggal_post);
        $cek->execute();
        $cek->store_result();

        $success = false;

        if ($cek->num_rows > 0) {
            if ($status === 'STAY') {
                $update = $koneksi->prepare("UPDATE absen SET sift = ?, stay = ? WHERE nama = ? AND tanggal = ?");
                $update->bind_param("ssss", $sift, $waktu, $nama_post, $tanggal_post);
            } elseif ($status === 'OFF') {
                $update = $koneksi->prepare("UPDATE absen SET off = ? WHERE nama = ? AND tanggal = ?");
                $update->bind_param("sss", $waktu, $nama_post, $tanggal_post);
            }
            $success = $update->execute();
            $update->close();
        } else {
            if ($status === 'STAY') {
                $insert = $koneksi->prepare("INSERT INTO absen (nama, tanggal, sift, stay) VALUES (?, ?, ?, ?)");
                $insert->bind_param("ssss", $nama_post, $tanggal_post, $sift, $waktu);
                $success = $insert->execute();
                $insert->close();
            } else {
                echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Gagal',
                text: 'Anda belum melakukan STAY hari ini.'
            }).then(() => {
                window.history.back();
            });
            </script>";
                exit;
            }
        }

        $cek->close();

        if ($success) {
            echo "<script>
        Swal.fire({
            icon: 'success',
            title: 'Berhasil',
            text: 'Absensi berhasil disimpan.'
        }).then(() => {
            window.location.href = 'index.php';
        });
        </script>";
        } else {
            echo "<script>
        Swal.fire({
            icon: 'error',
            title: 'Gagal',
            text: 'Terjadi kesalahan saat menyimpan data.'
        }).then(() => {
            window.history.back();
        });
        </script>";
        }
    }
    ?>

</body>

</html>