<?php
include 'auth.php';         // Mengecek login
include_once "koneksi.php";

if (!isset($_SESSION['user'])) {
  header("Location: login.php");
  exit;
}

$no_handphone = $_SESSION['user']['no_handphone'];
$nama = $_SESSION['user']['nama'];
$nama_asli = '';
$cek_nama_asli = mysqli_query($koneksi, "SELECT nama_asli FROM user WHERE nama = '$nama' LIMIT 1");
if ($cek_nama_asli && mysqli_num_rows($cek_nama_asli) > 0) {
  $row = mysqli_fetch_assoc($cek_nama_asli);
  $nama_asli = $row['nama_asli'];
}
// Ambil semua periode unik milik user untuk dropdown
$periode_list = [];
$stmt = $koneksi->prepare("SELECT DISTINCT periode FROM tabungan WHERE no_handphone = ? AND periode IS NOT NULL ORDER BY periode DESC");
$stmt->bind_param("s", $no_handphone);
$stmt->execute();
$result_periode = $stmt->get_result();
while ($row = $result_periode->fetch_assoc()) {
  $periode_list[] = $row['periode'];
}
$stmt->close();
// Cek apakah ada filter tanggal
$periode_filter = isset($_POST['periode_filter']) ? $_POST['periode_filter'] : date('Y-m');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['tanggal_filter']) && $_POST['tanggal_filter']) {
  $tanggal_filter = $_POST['tanggal_filter'];
  $query = $koneksi->prepare("
        SELECT created_at AS tanggal, tabungan_wajib, tabungan_sukarela 
        FROM tabungan 
        WHERE no_handphone = ? AND periode = ? AND DATE(created_at) = ? 
        ORDER BY created_at DESC
    ");
  $query->bind_param("sss", $no_handphone, $periode_filter, $tanggal_filter);
} else {
  $query = $koneksi->prepare("
        SELECT created_at AS tanggal, tabungan_wajib, tabungan_sukarela 
        FROM tabungan 
        WHERE no_handphone = ? AND periode = ? 
        ORDER BY created_at DESC
    ");
  $query->bind_param("ss", $no_handphone, $periode_filter);
}



$query->execute();
$result = $query->get_result();

$rows = [];
$total_sukarela = 0;

while ($row = $result->fetch_assoc()) {
  $rows[] = $row;
  $total_sukarela += $row['tabungan_sukarela'];
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <title>Tabungan Saya</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="css/navbar.css">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 10px;
      padding: 0;
      background-color: #1e2329;
      color: #fed054;
    }

    h4 {
      text-align: center;
      margin-bottom: 20px;
      margin-top: 20px;
      color: #fed054;
    }

    input,
    button,
    select {
      text-align: center;
      width: 100%;
      padding: 12px;
      font-size: 16px;
      margin-bottom: 3px;
      margin-top: 3px;
      background-color: rgb(255, 255, 255);
      color: #1e2329;
      box-sizing: border-box;
    }

    .table-container {
      max-height: 50vh;
      min-height: 50vh;
      overflow-y: auto;
      margin-top: 5px;
      border: 1px solid #2a2f35;
      position: relative;
      background-color: rgb(255, 255, 255);
      z-index: 1
    }

    table {
      width: 100%;
      table-layout: fixed;
      font-size: 16px;
      border-collapse: collapse;
      background-color: rgb(236, 236, 236);
    }

    thead th,
    tbody td {
      padding: 5px;
      text-align: center;
      border: 1px solid #3b4046;
      color: #1e2329;
      font-weight: bold;
      font-size: 14px;
      height: 25px;
      line-height: 1.2;
    }

    thead th {
      position: sticky;
      top: 0;
      background-color: #333;
      color: #fed054;
      z-index: 1;
    }

    .input-button-group {
      display: flex;
      gap: 10px;
    }

    .column {
      display: flex;
      flex-direction: column;
      gap: 10px;
    }

    .input-wrapper {
      position: relative;
      flex: 1;
    }

    .input-wrapper input {
      width: 100%;
      padding: 10px 10px 10px 40px;
      border-radius: 8px;
      background-color: #3b4046;
      border: 1px solid #fed054;
      color: #fed054;
      font-size: 14px;
      height: 42px;
      box-sizing: border-box;
    }

    .input-icon {
      position: absolute;
      top: 50%;
      left: 10px;
      transform: translateY(-50%);
      color: #fed054;
      font-size: 16px;
      pointer-events: none;
    }

    .buttons {
      justify-content: space-between;
    }

    button {
      border: 1px solid #ddd;
      border-radius: 8px;
      background: linear-gradient(to top, #f4b301, #fed054, #f4b301);
      transition: transform 0.2s ease, box-shadow 0.2s ease;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
      cursor: pointer;
      color: black;
      cursor: pointer;
      font-weight: bold;
      text-align: center;
      height: 50px;
    }

    button:hover {
      transform: scale(1.05);

    }

    .buttons .action-btn {
      background-color: #f1b400;
      border: none;
      padding: 0 16px;
      border-radius: 5px;
      color: black;
      font-weight: bold;
      font-size: 12px;
      cursor: pointer;
      height: 42px;
      width: 120px;
    }

    .total-box {
      text-align: center;
      margin-top: 10px;
      padding: 5px;
      position: sticky;
      top: 0;
      z-index: 10;
    }

    .icon-wrapper {
      position: relative;
      flex: 1 1 22%;
      min-width: 120px;
    }

    .input-container {
      display: flex;
      align-items: center;
    }

    .input-icon {
      margin-right: 5px;
      position: absolute;
      left: 10px;
      padding-left: 5px;
      top: 50%;
      transform: translateY(-50%);
      color: #f4b301;
      font-size: 18px;
      pointer-events: none;
    }

    .total-box input[type="text"] {
      text-align: center;
      font-weight: bold;
      color: #fed054;
      margin-top: 10px;
      background-color: #3b4046;
      border: 1px solid #fed054;
      border-radius: 6px;
      height: 40px;
      width: 100%;
      box-sizing: border-box;
      font-size: 18px;
    }

    .icon-wrapper label {
      display: block;
      margin-bottom: 10px;
      text-align: center;
      color: #fed054;
      font-weight: bold;
      font-size: 16px;
    }

    /* SweetAlert2 - Dark Mode Custom Styling */
    .swal2-popup {
      background: #3b4046 !important;
      color: #ffffff !important;
      border-radius: 12px;
      font-size: 16px;
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    /* Judul popup */
    .swal2-title {
      font-size: 20px;
      color: #fed054;
      text-align: center;
    }

    /* Input fields */
    .swal2-input {
      width: 100%;
      max-width: 250px;
      margin: 8px auto;
      background-color: #1e2329 !important;
      color: #ffffff !important;
      border: 1px solid #444 !important;
      border-radius: 8px;
      padding: 10px 12px;
      box-sizing: border-box;
    }

    /* Tombol Konfirmasi (Simpan) */
    .swal2-confirm {
      background-color: #f4b301 !important;
      color: #1e2329 !important;
      border-radius: 8px;
      padding: 10px 24px;
      margin-top: 10px;
      font-weight: 600;
    }

    /* Tombol Cancel */
    .swal2-cancel {
      background-color: #2a2f35 !important;
      color: #fff !important;
      border-radius: 8px;
      padding: 10px 24px;
      margin-top: 8px;
      font-weight: 500;
    }
  </style>
</head>

<body>
  <div class="container">
    <h4>Tabungan Sukarela</h4>
    <form method="POST">
      <div class="input-button-group">
        <div class="column">
          <div class="input-wrapper">
            <i class="fas fa-user input-icon"></i>
            <input type="text"  style="pointer-events: none;" value="<?= htmlspecialchars($nama_asli) ?>" readonly>
          </div>
          <div class="input-wrapper">
            <i class="fas fa-calendar-alt input-icon"></i>
            <select name="periode_filter"
              style="width: 100%; padding: 10px 10px 10px 40px; background-color: #3b4046; color: #fed054; border: 1px solid #fed054; border-radius: 8px; font-size: 14px; height: 42px;">
              <option value="">Pilih Bulan</option>
              <?php foreach ($periode_list as $periode): ?>
                <option value="<?= $periode ?>" <?= (isset($_POST['periode_filter']) && $_POST['periode_filter'] === $periode) ? 'selected' : '' ?>>
                  <?= date("F Y", strtotime($periode . "-01")) ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>
        </div>
        <div class="column buttons">
          <button type="button" class="action-btn" onclick="window.location.href='menu_tabungan1.php';">➥ Wajib</button>
          <button type="submit" class="action-btn">Filter Tanggal</button>
        </div>
      </div>
    </form>

    <!-- Tampilkan total wajib dulu -->
    <div class="total-box">
      <label for="orderan">Total Tabungan Sukarela</label>
      <div class="input-container">
        <input type="text"  style="pointer-events: none;" readonly value="Rp <?= number_format($total_sukarela, 0, ',', '.') ?>"
          placeholder="Total Tabungan" />
      </div>
    </div>

    <!-- Tampilkan tabelnya setelahnya -->
    <div class="table-container">
      <table>
        <thead>
          <tr>
            <th>Tanggal</th>
            <th>Nominal</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $row): ?>
            <tr>
              <td><?= date("d-m-Y", strtotime($row['tanggal'])) ?></td>
              <td>Rp <?= number_format($row['tabungan_sukarela'], 0, ',', '.') ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
    <?php include 'navbar3.php'; ?>

    <script>
      Swal.fire({
        icon: 'success',
        title: 'Tabungan Sukarela',
        text: 'Beralih ke Tabungan Sukarela.',
        showConfirmButton: false,
        timer: 500,
        timerProgressBar: true,
      });
    </script>

</body>

</html>