<?php
include 'auth.php'; // Cek login
?>
<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <link rel="stylesheet" href="css/navbar.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <title>Notebook Lokal</title>
  <style>
        .flex-btns {
      display: flex;
      justify-content: space-between;
      gap: 10px;
      padding-left: 10px;
      padding-right: 10px;
      margin-top: 10px;
      flex-wrap: wrap;
    }

    .flex-btns button:hover {
      background-color: #f5d216;
    }

    .flex-btns button {
      cursor: pointer;
      font-size: 18px;
      transition: background-color 0.2s ease;
      border: 1px solid #fed054;
      border-radius: 8px;
      height: 50px;
      font-size: 26px;
      flex: 1;
      min-width: 50px;
      padding: 10px;
      text-align: center;
      box-sizing: border-box;
    }
    body {
      margin: 0;
      padding: 20px;
      font-family: 'Segoe UI', Tahoma, sans-serif;
      background-color: #1e2329;
      color: #fed054;
    }

    h1,
    h4 {
      color: #fed054;
      text-align: center;
      margin-bottom: 20px;
    }

    .form-group {
      margin-bottom: 15px;
    }

    label {
      display: block;
      margin-bottom: 5px;
      font-weight: bold;
    }

    input,
    textarea,
    button {
      width: 100%;
      padding: 10px;
      font-size: 16px;
      border-radius: 6px;
      border: 1px solid #fed054;
      background-color: #3b4046;
      color: #ebeae8;
      box-sizing: border-box;
    }

    textarea {
      resize: vertical;
      min-height: 100px;
    }

    button {
      margin-top: 10px;
      background: linear-gradient(to top, #f4b301, #fed054, #f4b301);
      color: black;
      font-weight: bold;
      cursor: pointer;
      border: none;
    }

    button:hover {
      transform: scale(1.05);
    }

    .note-list {
      margin-top: 30px;
    }

    .note-item {
      background-color: #2a2f35;
      padding: 10px 15px;
      margin-bottom: 10px;
      border-radius: 8px;
      border: 1px solid #fed054;
      cursor: pointer;
      transition: background-color 0.2s;
    }

    .note-item:hover {
      background-color: #3b3b3b;
    }

    .note-title {
      font-weight: bold;
      color: #fed054;
    }

    .note-date {
      font-size: 13px;
      color: #ccc;
    }

    .note-detail {
      margin-top: 10px;
      border: 1px solid #444;
      background-color: #2a2f35;
      padding: 10px;
      border-radius: 6px;
      color: #ccc;
      display: none;
    }

    .note-actions {
      margin-top: 10px;
      display: flex;
      justify-content: flex-end;
      gap: 10px;
    }

    .note-actions button {
      flex: 1;
      padding: 8px;
      font-size: 14px;
      border-radius: 6px;
    }

    .edit-btn {
      background-color: #3498db;
      color: #1e2329;
    }

    .edit-btn:hover {
      background-color: #2980b9;
    }

    .delete-btn {
      background-color: #e74c3c;
      color: #1e2329;
    }

    .delete-btn:hover {
      background-color: #c0392b;
    }

    @media (max-width: 600px) {
      .note-actions {
        flex-direction: column;
      }
    }

    /* SweetAlert2 - Dark Mode Custom Styling */
    .swal2-popup {
      background: #3b4046 !important;
      color: #ffffff !important;
      border-radius: 12px;
      font-size: 16px;
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    /* Judul popup */
    .swal2-title {
      font-size: 20px;
      color: #fed054;
      text-align: center;
    }

    /* Input fields */
    .swal2-input {
      width: 100%;
      max-width: 250px;
      margin: 8px auto;
      background-color: #1e2329 !important;
      color: #ffffff !important;
      border: 1px solid #444 !important;
      border-radius: 8px;
      padding: 10px 12px;
      box-sizing: border-box;
    }

    /* Tombol Konfirmasi (Simpan) */
    .swal2-confirm {
      background-color: #f4b301 !important;
      color: #1e2329 !important;
      border-radius: 8px;
      padding: 10px 24px;
      margin-top: 10px;
      font-weight: 600;
    }

    /* Tombol Cancel */
    .swal2-cancel {
      background-color: #2a2f35 !important;
      color: #fff !important;
      border-radius: 8px;
      padding: 10px 24px;
      margin-top: 8px;
      font-weight: 500;
    }

    .note-list {
      display: none;
      /* Disembunyikan di awal */
      margin-top: 30px;
    }

    h3 {
      text-align: center;
      margin-bottom: 10px;
      margin-top: 30px;
      color: #fed054;
    }
  </style>
</head>

<body>

  <h3>CATATAN</h3>

  <div class="form">
    <div class="form-group">
      <label for="tanggal">Tanggal</label>
      <input type="date" id="tanggal">
    </div>

    <div class="form-group">
      <label for="judul">Judul</label>
      <input type="text" id="judul" placeholder="Judul catatan" autocomplete="off">
    </div>

    <div class="form-group">
      <label for="isi">Catatan</label>
      <textarea id="isi" placeholder="Tulis catatan di sini..."></textarea>
    </div>

    <button onclick="simpanCatatan()">Simpan Catatan</button>
  </div>

  <div class="note-list" id="noteList">
    <h2>Daftar Catatan</h2>
    <!-- Catatan akan ditampilkan di sini -->
  </div>
  <?php include 'navbar4.php'; ?>
  <script>
    let editingIndex = null;

    function simpanCatatan() {
      const tanggal = document.getElementById('tanggal').value;
      const judul = document.getElementById('judul').value;
      const isi = document.getElementById('isi').value;

      if (!tanggal || !judul || !isi) {
        Swal.fire({
          icon: 'warning',
          title: 'Lengkapi Data!',
          text: 'Semua kolom harus diisi.'
        });
        return;
      }

      let catatan = JSON.parse(localStorage.getItem('catatan') || '[]');
      const dataBaru = { tanggal, judul, isi };

      if (editingIndex !== null) {
        catatan[editingIndex] = dataBaru;
        editingIndex = null;
      } else {
        catatan.push(dataBaru);
      }

      localStorage.setItem('catatan', JSON.stringify(catatan));
      resetForm();
      tampilkanCatatan();

      Swal.fire({
        icon: 'success',
        title: 'Tersimpan!',
        text: 'Catatan berhasil disimpan.',
        timer: 1500,
        showConfirmButton: false
      });
    }


    function tampilkanCatatan() {
      const catatan = JSON.parse(localStorage.getItem('catatan') || '[]');
      const noteList = document.getElementById('noteList');
      const wrapper = noteList;

      if (catatan.length === 0) {
        wrapper.style.display = 'none';
        return;
      } else {
        wrapper.style.display = 'block';
      }

      noteList.innerHTML = '<h4>Daftar Catatan</h4>';

      catatan.forEach((item, index) => {
        const wrapperItem = document.createElement('div');

        const noteItem = document.createElement('div');
        noteItem.className = 'note-item';
        noteItem.innerHTML = `
      <div class="note-title">${item.judul}</div>
      <div class="note-date">${item.tanggal}</div>
    `;

        const noteDetail = document.createElement('div');
        noteDetail.className = 'note-detail';
        noteDetail.innerHTML = `
      <div>${item.isi}</div>
      <div class="note-actions">
        <button class="edit-btn" onclick="editCatatan(${index})">Edit</button>
        <button class="delete-btn" onclick="hapusCatatan(${index})">Hapus</button>
      </div>
    `;

        noteItem.addEventListener('click', () => {
          const allDetails = document.querySelectorAll('.note-detail');
          allDetails.forEach(d => d.style.display = 'none');
          noteDetail.style.display = noteDetail.style.display === 'block' ? 'none' : 'block';
        });

        wrapperItem.appendChild(noteItem);
        wrapperItem.appendChild(noteDetail);
        noteList.appendChild(wrapperItem);
      });
    }


    function hapusCatatan(index) {
      Swal.fire({
        title: 'Yakin ingin menghapus?',
        text: "Catatan akan dihapus permanen.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#e74c3c',
        cancelButtonColor: '#888',
        confirmButtonText: 'Ya, hapus!'
      }).then((result) => {
        if (result.isConfirmed) {
          let catatan = JSON.parse(localStorage.getItem('catatan') || '[]');
          catatan.splice(index, 1);
          localStorage.setItem('catatan', JSON.stringify(catatan));
          tampilkanCatatan();

          Swal.fire({
            icon: 'success',
            title: 'Terhapus!',
            text: 'Catatan telah dihapus.',
            timer: 1500,
            showConfirmButton: false
          });
        }
      });
    }


    function editCatatan(index) {
      const catatan = JSON.parse(localStorage.getItem('catatan') || '[]');
      const data = catatan[index];
      document.getElementById('tanggal').value = data.tanggal;
      document.getElementById('judul').value = data.judul;
      document.getElementById('isi').value = data.isi;
      editingIndex = index;
      window.scrollTo({ top: 0, behavior: 'smooth' });
    }

    function resetForm() {
      document.getElementById('tanggal').value = '';
      document.getElementById('judul').value = '';
      document.getElementById('isi').value = '';
    }

    window.onload = tampilkanCatatan;
  </script>
</body>

</html>