<?php
session_start();
include 'koneksi.php';

// Anggap session sudah menyimpan nama user
$nama_user = $_SESSION['user']['nama_asli'];

// Tentukan awal dan akhir minggu (Jumat sampai Kamis)
$hari_ini = date('Y-m-d');
$timestamp_hari_ini = strtotime($hari_ini);
$hari_keberapa = date('w', $timestamp_hari_ini); // 0 = Minggu, 5 = Jumat
$selisih_hari = ($hari_keberapa >= 5) ? $hari_keberapa - 5 : 7 - (5 - $hari_keberapa);
$tanggal_awal_minggu = date('Y-m-d', strtotime("-$selisih_hari days", $timestamp_hari_ini));
$tanggal_akhir_minggu = $hari_ini;

// Hitung total orderan selama minggu ini
$stmt_mingguan = $koneksi->prepare("SELECT SUM(orderan) as total FROM transaksi WHERE nama = ? AND tanggal BETWEEN ? AND ?");
$stmt_mingguan->bind_param("sss", $nama_user, $tanggal_awal_minggu, $tanggal_akhir_minggu);
$stmt_mingguan->execute();
$result_mingguan = $stmt_mingguan->get_result();
$data_mingguan = $result_mingguan->fetch_assoc();
$total_orderan_mingguan = $data_mingguan['total'] ?? 0;

// Cek status target
$target_mingguan = 50;
$status_mingguan = ($total_orderan_mingguan >= $target_mingguan) ? "SUKSES" : "TARGET";


// Ambil bulan yang dipilih dari form
$bulan = $_GET['bulan'] ?? date('Y-m');

// Format untuk query SQL (misal: 2025-06)
$bulan_filter = $bulan . '%';

// Ambil data total pendapatan bulanan
$sql_total = "SELECT SUM(total_pendapatan) as total_bulanan 
    FROM transaksi 
    WHERE nama='$nama_user' AND tanggal LIKE '$bulan_filter'";
$query_total = mysqli_query($koneksi, $sql_total);

if (!$query_total) {
    die("Query Error: " . mysqli_error($koneksi));
}

// Ambil total orderan selama bulan tersebut
$sql_orderan = "SELECT SUM(orderan) as total_orderan 
    FROM transaksi 
    WHERE nama='$nama_user' AND tanggal LIKE '$bulan_filter'";
$query_orderan = mysqli_query($koneksi, $sql_orderan);

if (!$query_orderan) {
    die("Query Error: " . mysqli_error($koneksi));
}

$data_orderan = mysqli_fetch_assoc($query_orderan);
$total_orderan = $data_orderan['total_orderan'] ?? 0;


$data_total = mysqli_fetch_assoc($query_total);

$total_bulanan = $data_total['total_bulanan'] ?? 0;

// Ambil data harian per tanggal
$query_harian = mysqli_query($koneksi, "
    SELECT tanggal, total_pendapatan, orderan 
    FROM transaksi 
    WHERE nama='$nama_user' AND tanggal LIKE '$bulan_filter' 
    ORDER BY tanggal DESC
");
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Penghasilan</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="css/navbar.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
</head>
<style>
    body {
        margin: 0;
        padding: 0;
        font-family: 'Segoe UI', Roboto, Arial;
        background-color: #071733;
        color: #1e2329;
    }

    .container {
        padding-left: 16px;
        padding-right: 16px;
        max-width: 480px;
        margin: auto;
    }

    h6 {
        text-align: center;
        color: rgb(197, 197, 197);
        margin-bottom: 20px;
    }

    h4 {
        text-align: center;
        color: #fed054;
        margin-bottom: 20px;
    }

    .info-box {
        display: flex;
        align-items: center;
        background: #233a6a;
        border: 2px solid rgba(255, 255, 255, 0.35);
        border-radius: 10px;
        margin-bottom: 10px;
    }

    .info-box i {
        margin-right: 10px;
        color: #facc15;
    }

    .info-box input,
    .info-box select {
        background-color: #233a6a;
        color: #fed054;
        border: none;
        flex: 1;
        font-size: 16px;
        outline: none;
    }

    .order-box {
        text-align: center;
        background-color: #233a6a;
        border: 2px solid #facc15;
        border-radius: 10px;
        color: rgb(38, 254, 0);
        padding: 12px;
        font-size: 22px;
        font-weight: bold;
        margin-bottom: 16px;
    }

    .table-container {
        max-height: 45vh;
        min-height: 45vh;
        overflow-y: auto;
        margin-top: 10px;
        border: 1px solid #2a2f35;
        position: relative;
        background-color: rgb(255, 255, 255);
        z-index: 1
    }

    table {
        width: 100%;
        table-layout: fixed;
        font-size: 16px;
        border-collapse: collapse;
        background-color: rgb(236, 236, 236);
    }

    thead th,
    tbody td {
        padding: 6px;
        text-align: center;
        border: 1px solid #444;
    }

    table th,
    table td {
        padding: 2px 4px;
        font-size: 12px;
        height: 30px;
        line-height: 1.2;
    }

    thead th {
        position: sticky;
        top: 0;
        background-color: #233a6a;
        border: 1px solid rgba(255, 255, 255, 0.35);
        color: #f5d216;
        z-index: 1;
    }

    /* Tambahkan gaya input dalam tabel agar lebih kecil */
    table td input[type="text"],
    table td input[type="number"] {
        font-size: 14px;
        padding: 3px 5px;
        height: 30px;
        box-sizing: border-box;
        text-align: center;
    }

    table button {
        font-size: 10px;
        padding: 2px 4px;
        height: 24px;
        line-height: 1;
    }

    /* Tombol hapus di dalam tabel */
    table td button {
        background-color: rgb(43, 206, 2);
        color: white;
        font-size: 10px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        width: 50px;
        height: 20px;
    }

    button {
        background-color: #facc15;
        border: none;
        color: #111;
        padding: 4px 10px;
        border-radius: 6px;
        font-size: 13px;
        font-weight: bold;
        cursor: pointer;
    }

    .footer-box {
        margin-top: 14px;
        padding-top: 10px;
        border-top: 1px solid #444;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .footer-box input {
        background-color: #233a6a;
        border: 3px solid rgba(255, 255, 255, 0.35);
        border-radius: 8px;
        padding: 6px 10px;
        color: #fff;
        font-weight: bold;
        font-size: 16px;
        width: 140px;
        height: 20px;
        padding-right: 20px;
        text-align: right;
    }

    /* SweetAlert2 - Navy Glassmorphism + Margin */
    .swal2-popup {
        background: rgba(30, 45, 80, 0.35) !important;
        backdrop-filter: blur(14px) !important;
        -webkit-backdrop-filter: blur(14px) !important;
        /* Margin agar ada jarak dari sisi layar */
        margin-left: 500px !important;
        margin-right: 500px !important;
        border: 2px solid rgba(90, 120, 180, 0.4);
        border-radius: 16px;
        color: #ffffff !important;
        font-size: 16px;
        box-shadow: 0 100px 28px rgba(0, 0, 0, 0.35);
        display: flex;
        flex-direction: column;
        align-items: center;
    }

    /* Judul popup */
    .swal2-title {
        font-size: 20px;
        color: #ffffffff;
        text-align: center;
    }

    /* Input fields */
    .swal2-input {
        width: 100%;
        max-width: 250px;
        margin: 8px auto;
        background-color: #1e2329 !important;
        color: #ffffff !important;
        border: 1px solid #444 !important;
        border-radius: 8px;
        padding: 10px 12px;
        box-sizing: border-box;
    }

    /* Base styling untuk semua tombol SweetAlert */
    .swal2-styled {
        padding: 14px 26px !important;
        font-size: 17px !important;
        font-weight: 700 !important;
        border-radius: 14px !important;
        backdrop-filter: blur(10px) !important;
        -webkit-backdrop-filter: blur(10px) !important;
        box-shadow:
            0 10px 18px rgba(0, 0, 0, 0.35),
            inset 0 5px 8px rgba(255, 255, 255, 0.22),
            inset 0 -5px 8px rgba(0, 0, 0, 0.30);
        transition: 0.22s ease !important;
    }

    /* Hover umum */
    .swal2-styled:hover {
        transform: translateY(-3px);
    }

    /* Active umum */
    .swal2-styled:active {
        transform: translateY(3px);
    }

    /* --------------------------- */
    /*  STAY (Hijau Glass)         */
    /* --------------------------- */
    .swal2-confirm {
        background: rgba(40, 150, 80, 0.45) !important;
        /* hijau transparan */
        border: 2px solid rgba(120, 230, 160, 0.5) !important;
        color: #fff !important;
        box-shadow:
            0 10px 18px rgba(0, 0, 0, 0.35),
            inset 0 6px 10px rgba(255, 255, 255, 0.20),
            inset 0 -6px 10px rgba(0, 0, 0, 0.35);
    }

    .swal2-confirm:hover {
        background: rgba(55, 180, 110, 0.55) !important;
    }

    /* --------------------------- */
    /*  OFF (Merah Glass)          */
    /* --------------------------- */
    .swal2-deny {
        background: rgba(180, 40, 60, 0.45) !important;
        /* merah transparan */
        border: 2px solid rgba(255, 150, 150, 0.5) !important;
        color: #fff !important;
    }

    .swal2-deny:hover {
        background: rgba(210, 55, 80, 0.55) !important;
    }

    /* --------------------------- */
    /*  Batal (Hitam Glass)        */
    /* --------------------------- */
    .swal2-cancel {
        background: rgba(20, 20, 20, 0.45) !important;
        /* hitam transparan */
        border: 2px solid rgba(180, 180, 180, 0.4) !important;
        color: #fff !important;
    }

    .swal2-cancel:hover {
        background: rgba(40, 40, 40, 0.55) !important;
    }


    /* Tombol shift 3D - Glass Navy Cembung */
    .swal-shift-btn {
        padding: 16px 20px;
        min-width: 80px;
        font-size: 18px;
        font-weight: 700;
        color: #ffffff;

        /* Tambahkan jarak antar tombol */
        margin: 0 6px;

        /* Glass navy */
        background: rgba(40, 60, 110, 0.45);
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);

        border-radius: 18px;
        border: 2px solid rgba(180, 200, 255, 0.45);

        cursor: pointer;
        transition: 0.22s ease;

        /* --- Efek 3D tonjol keluar --- */
        box-shadow:
            0 12px 18px rgba(0, 0, 0, 0.45),
            inset 0 6px 10px rgba(255, 255, 255, 0.25),
            inset 0 -6px 10px rgba(0, 0, 0, 0.35),
            0 0 14px rgba(90, 120, 200, 0.5);
    }

    /* Hover: makin menonjol */
    .swal-shift-btn:hover {
        transform: translateY(-4px);
        box-shadow:
            0 16px 22px rgba(0, 0, 0, 0.55),
            inset 0 7px 11px rgba(255, 255, 255, 0.28),
            inset 0 -7px 11px rgba(0, 0, 0, 0.4),
            0 0 16px rgba(110, 140, 230, 0.6);
    }

    /* Active: ditekan */
    .swal-shift-btn:active {
        transform: translateY(3px);
        box-shadow:
            0 7px 10px rgba(0, 0, 0, 0.45),
            inset 0 3px 6px rgba(255, 255, 255, 0.18),
            inset 0 -4px 7px rgba(0, 0, 0, 0.35),
            0 0 12px rgba(90, 120, 200, 0.45);
    }

    /* Base styling untuk semua tombol SweetAlert */
    .swal2-popup .swal2-styled {
        padding: 14px 26px !important;
        font-size: 17px !important;
        font-weight: 700 !important;
        border-radius: 14px !important;
        backdrop-filter: blur(10px) !important;
        -webkit-backdrop-filter: blur(10px) !important;
        box-shadow:
            0 10px 18px rgba(0, 0, 0, 0.35),
            inset 0 5px 8px rgba(255, 255, 255, 0.22),
            inset 0 -5px 8px rgba(0, 0, 0, 0.30);
        transition: 0.22s ease !important;
    }

    /* Hover khusus SweetAlert */
    .swal2-popup .swal2-styled:hover {
        transform: translateY(-3px);
    }

    /* Active khusus SweetAlert */
    .swal2-popup .swal2-styled:active {
        transform: translateY(3px);
    }

    /* STAY / OK (Hijau Glass) */
    /* SweetAlert Confirm (OK) tengah sempurna */
    .swal2-popup .swal2-confirm {
        background: rgba(40, 150, 80, 0.45) !important;
        border: 2px solid rgba(120, 230, 160, 0.5) !important;
        color: #fff !important;

        padding: 14px 28px !important;
        /* lebih seimbang */

        /* perbaikan posisi text */
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;

        /* efek glass 3D tapi tidak membuat teks turun */
        box-shadow:
            0 6px 12px rgba(0, 0, 0, 0.35),
            /* bayangan bawah dikurangi */
            inset 0 4px 7px rgba(255, 255, 255, 0.25),
            /* highlight atas */
            inset 0 -3px 6px rgba(0, 0, 0, 0.25);
        /* shading bawah dikurangi */
    }

    /* OFF (Merah Glass) */
    .swal2-popup .swal2-deny {
        background: rgba(180, 40, 60, 0.45) !important;
        border: 2px solid rgba(255, 150, 150, 0.5) !important;
        color: #fff !important;
    }

    /* Batal (Hitam Glass) */
    .swal2-popup .swal2-cancel {
        background: rgba(20, 20, 20, 0.45) !important;
        border: 2px solid rgba(180, 180, 180, 0.4) !important;
        color: #fff !important;
    }

    /* Hilangkan garis animasi */
    .swal2-success-ring,
    .swal2-success-fix {
        background: none !important;
        display: none !important;
    }

    /* Hapus inner circle */
    .swal2-success-circular-line-left,
    .swal2-success-circular-line-right {
        display: none !important;
    }
</style>

<body>
    <h4>Rincian Bulanan</h4>

    <div class="container">

        <div style="display: flex; gap: 10px; flex-wrap: wrap;">

            <!-- Nama -->
            <div class="info-box" style="display: flex; align-items: center; flex: 1; min-width: 140px; padding-left:8px; border-radius: 6px; color: #fed054;">
                <i class="fas fa-user" style="color: #fed054; margin-right: 6px;"></i>
                <span style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis;"><?= htmlspecialchars($nama_user) ?></span>
            </div>

            <!-- Dropdown Bulan -->
            <form method="get" id="formBulan" style="margin: 0; flex: 1; min-width: 140px;">
                <div class="info-box" style="display: flex; align-items: center; padding: 8px 12px; border-radius: 6px;">
                    <i class="fas fa-calendar-alt" style="color: #fed054; margin-right: 6px;"></i>
                    <select name="bulan" onchange="document.getElementById('formBulan').submit();"
                        style="height:20px; background: transparent; border: none; color: #fed054; font-size: 14px; outline: none; width: 100%;">
                        <option value="">Pilih Bulan</option>
                        <?php foreach ($periode_list as $periode): ?>
                            <option value="<?= $periode ?>" <?= ($periode === $bulan) ? 'selected' : '' ?>>
                                <?= date("F Y", strtotime($periode . "-01")) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </form>

        </div>

        <?php
        $warna_total = ($total_orderan_mingguan >= $target_mingguan) ? '#00ff36' : '#fed054';
        ?>

        <div style="background-color: #233a6a; margin-top: 5px; margin-bottom: 15px; text-align: center; border: 2px solid rgba(255,255,255,0.35); border-radius: 8px; padding: 5px;">
            <!-- Judul -->
            <div style="
    font-size: 14px;
    background-color: #233a6a;
    color: #fed054;
    border-bottom: 2px solid rgba(255,255,255,0.35);
    padding-bottom: 5px;
    margin-bottom: 5px;
  ">
                TOTAL ORDERAN MINGGU INI
            </div>

            <!-- Konten dua kolom dengan pemisah tengah -->
            <div style="background-color: #233a6a; display: flex; justify-content: center; align-items: center; text-align: center;">

                <!-- Kolom Status -->
                <div style="width: 50%; border-right: 2px solid rgba(255,255,255,0.35);">
                    <div style="
        color: <?= ($total_orderan_mingguan >= $target_mingguan) ? '#00ff36' : '#fed054' ?>;
        padding: 6px 15px;
        border-radius: 8px;
        font-weight: bold;
        font-size: 20px;
        display: inline-block;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
      ">
                        <?= ($total_orderan_mingguan >= $target_mingguan) ? 'SUKSES' : 'PROGRES' ?>
                    </div>
                </div>

                <!-- Kolom Angka -->
                <div style="width: 50%;">
                    <div style="font-size: 26px; font-weight: bold;">
                        <span style="color: <?= $warna_total ?>;"><?= $total_orderan_mingguan ?> /</span>
                        <span style="color: #00ff36;"> <?= $target_mingguan ?></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Tanggal</th>
                        <th>Orderan</th>
                        <th>Pendapatan</th>
                        <th>Detail</th>
                    </tr>
                </thead>
                <tbody id="tabelBody">
                    <?php while ($row = mysqli_fetch_assoc($query_harian)): ?>
                        <tr>
                            <td><?= $row['tanggal'] ?></td>
                            <td><?= $row['orderan'] ?></td>
                            <td>Rp <?= number_format($row['total_pendapatan'], 0, ',', '.') ?></td>
                            <td>
                                <button onclick="tampilkanDetail('<?= $row['tanggal'] ?>')">Lihat</button>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <div class="footer-box">
            <span style="color: #fed054;">Total Bulan Ini :</span>
            <input style="pointer-events: none;" type="text" readonly value="<?= number_format($total_orderan, 0, ',', '.') ?>">
        </div>

        <div class="footer-box">
            <span style="color: #fed054;">Total Pendapatan :</span>
            <input style="pointer-events: none;" type="text" readonly value="Rp <?= number_format($total_bulanan, 0, ',', '.') ?>">
        </div>
    </div>

    <?php include 'navbar3.php'; ?>

    <script>
        function tampilkanDetail(tanggal) {
            fetch('detail_penghasilan.php?tanggal=' + tanggal)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        let html = `
                    <div style="font-size: 16px; font-family: 'Segoe UI', sans-serif; color: #1e2329;">
                        <table style="border: 2px solid #555; border-radius: 8px; width: 100%; border-collapse: collapse; margin-bottom: 10px;">
                            <tr>
                                <td style="text-align: left; padding: 8px 8px; color: #1e2329;">➢ Orderan</td>
                                <td style="font-weight: bold; padding-right:10px; text-align: right;">${data.orderan}</td>
                            </tr>
                            <tr>
                                <td style="text-align: left; padding: 8px 8px; color: #1e2329;">➢ Total Ongkir</td>
                                <td style="font-weight: bold; padding-right:10px; text-align: right;">Rp ${formatRupiah(data.total_ongkir)}</td>
                            </tr>
                            <tr>
                                <td style="text-align: left; padding: 8px 8px; color: #1e2329;">➢ Potongan</td>
                                <td style="font-weight: bold; padding-right:10px; text-align: right;">Rp ${formatRupiah(data.potongan)}</td>
                            </tr>
                            <tr>
                                <td style="text-align: left; padding: 8px 8px; color: #1e2329;">➢ Tabungan</td>
                                <td style=" font-weight: bold; padding-right:10px;text-align: right;">Rp ${formatRupiah(data.tabungan)}</td>
                            </tr>
                            <tr>
                                <td style="text-align: left; padding: 8px 8px; color: #1e2329;">➢ Total Setoran</td>
                                <td style="font-weight: bold; padding-right:10px; text-align: right;">Rp ${formatRupiah(data.total_setoran)}</td>
                            </tr>
                        </table>
                        <div style="border-top: 1px solid #444; margin-top: 10px; padding-top: 10px;">
                            <div style="font-weight: bold; color: #facc15; font-size: 16px;">Total Pendapatan:</div>
                            <div style="font-size: 20px; font-weight: bold; color: #facc15;">Rp ${formatRupiah(data.total_pendapatan)}</div>
                        </div>
                    </div>
                `;
                        Swal.fire({
                            title: '<strong style="color:#facc15; font-size: 20px;">Rincian Pendapatan</strong>',
                            html: html,
                            confirmButtonText: 'Tutup',
                            confirmButtonColor: '#facc15',
                            background: '#1f1f1f',
                            color: '#fff',
                            width: 420,
                            padding: '10px'
                        });
                    } else {
                        Swal.fire('Data tidak ditemukan!', '', 'error');
                    }
                });
        }


        function formatRupiah(angka) {
            return new Intl.NumberFormat('id-ID').format(angka);
        }
    </script>
</body>

</html>