<?php
session_start();
include "koneksi.php";

if (!isset($_SESSION['id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['id'];
$q = mysqli_query($koneksi, "SELECT * FROM user WHERE id='$user_id'");
$data = mysqli_fetch_assoc($q);
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <title>Akun Saya</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <style>
        body {
            margin: 0;
            background: #071733;
            font-family: 'Segoe UI', Roboto, Arial;
            color: #fff;
        }

        /* =====================
       HEADER MINI ATAS
    ======================*/
        .header-mini {
            background: #071733;
            padding: 10px 14px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border: 3px solid rgba(255, 255, 255, 0.24);
            border-radius: 10px;
            margin: 15px;
            box-shadow: 0 1px 0 rgba(226, 223, 223, 0.3);
        }

        .mini-logo {
            width: 130px;
            object-fit: contain;
        }

        .wa-btn {
            background: #233a6a;
            border: none;
            padding: 8px 14px;
            color: #ffd800;
            font-size: 14px;
            border-radius: 8px;
            font-weight: 500;
            box-shadow: inset 0 -3px 0 rgba(0, 0, 0, 0.25), 0 3px 6px rgba(0, 0, 0, 0.25);
            transition: 0.2s;
        }

        .wa-btn:hover {
            background: #2a4a8a;
            transform: translateY(-2px);
            box-shadow: inset 0 -3px 0 rgba(0, 0, 0, 0.2), 0 6px 12px rgba(0, 0, 0, 0.28);
        }

        /* =====================
       CARD PROFIL
    ======================*/
        .profile-card {
            max-width: 360px;
            margin: 20px;
            padding: 20px 20px 60px 20px;
            /* PENTING: tambah padding bawah 60px */
            background: #233a6a;
            border: 4px solid rgba(255, 255, 255, 0.06);
            border-radius: 14px;
            box-shadow: 0 10px 0 rgba(0, 0, 0, 0.35);
            text-align: center;
            position: relative;
            /* opsional */
        }


        .profile-title {
            color: #ffd800;
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 15px;
        }

        .photo-frame {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            margin: auto;
            border: 4px solid #ffd800;
            overflow: hidden;
            background: #444;
            display: flex;
            justify-content: center;
            align-items: center;
            cursor: pointer;
            box-shadow:
                inset 0 2px 4px rgba(255, 255, 255, 0.35),
                0 4px 10px rgba(0, 0, 0, 0.3);
        }

        .photo-frame img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        /* ======================
       TABLE CARD NAVY GOLD
    =======================*/
        .table-card {
            width: 100%;
            background: #1f4f82;
            border-radius: 14px;
            margin-top: 18px;
            margin-bottom: 30px;
            /* ruang antar tabel & tombol */
            border: 3px solid rgba(255, 255, 255, 0.22);
            box-shadow:
                inset 0 1px 3px rgba(255, 255, 255, 0.35),
                0 6px 12px rgba(0, 0, 0, 0.25);
            overflow: hidden;
        }


        .table-card table {
            width: 100%;
            border-collapse: collapse;
        }

        .table-card th {
            width: 35%;
            padding: 14px;
            background: rgba(255, 255, 255, 0.12);
            color: #ffd800;
            font-size: 14px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.18);
        }

        .table-card td {
            padding: 14px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.18);
            font-size: 14px;
        }

        .table-card tr:last-child th,
        .table-card tr:last-child td {
            border-bottom: none;
        }

        /* =====================
       BUTTON 3D KUNING
    ======================*/
        .gold-btn {
            width: 100%;
            margin-top: 25px;
            margin-bottom: 5px;
            /* Diperbaiki dari 140px → 20px */
            background: linear-gradient(#ffe680, #ffcc00);
            color: #04003a;
            border: none;
            padding: 12px;
            font-weight: 700;
            border-radius: 12px;
            text-decoration: none;
            /* <-- HILANGKAN GARIS BAWAH */
            box-shadow:
                0 6px 0 #d1a700,
                0 4px 10px rgba(0, 0, 0, 0.18),
                inset 0 2px 4px rgba(255, 255, 255, 0.45);
            transition: 0.2s;
        }

        .gold-btn:hover {
            transform: translateY(-3px);
            box-shadow:
                0 9px 0 #d1a700,
                0 6px 14px rgba(0, 0, 0, 0.24),
                inset 0 2px 5px rgba(255, 255, 255, 0.5);
        }

        .gold-btn:active {
            transform: translateY(2px);
            box-shadow:
                0 3px 0 #d1a700,
                0 2px 6px rgba(0, 0, 0, 0.22),
                inset 0 4px 6px rgba(0, 0, 0, 0.25);
        }

        /* SweetAlert2 - Navy Glassmorphism + Margin */
        .swal2-popup {
            background: rgba(30, 45, 80, 0.35) !important;
            backdrop-filter: blur(14px) !important;
            -webkit-backdrop-filter: blur(14px) !important;
            /* Margin agar ada jarak dari sisi layar */
            margin-left: 500px !important;
            margin-right: 500px !important;
            border: 2px solid rgba(90, 120, 180, 0.4);
            border-radius: 16px;
            color: #ffffff !important;
            font-size: 16px;
            box-shadow: 0 100px 28px rgba(0, 0, 0, 0.35);
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        /* Judul popup */
        .swal2-title {
            font-size: 20px;
            color: #ffffffff;
            text-align: center;
        }

        /* Input fields */
        .swal2-input {
            width: 100%;
            max-width: 250px;
            margin: 8px auto;
            background-color: #1e2329 !important;
            color: #ffffff !important;
            border: 1px solid #444 !important;
            border-radius: 8px;
            padding: 10px 12px;
            box-sizing: border-box;
        }

        /* Base styling untuk semua tombol SweetAlert */
        .swal2-styled {
            padding: 14px 26px !important;
            font-size: 17px !important;
            font-weight: 700 !important;
            border-radius: 14px !important;
            backdrop-filter: blur(10px) !important;
            -webkit-backdrop-filter: blur(10px) !important;
            box-shadow:
                0 10px 18px rgba(0, 0, 0, 0.35),
                inset 0 5px 8px rgba(255, 255, 255, 0.22),
                inset 0 -5px 8px rgba(0, 0, 0, 0.30);
            transition: 0.22s ease !important;
        }

        /* Hover umum */
        .swal2-styled:hover {
            transform: translateY(-3px);
        }

        /* Active umum */
        .swal2-styled:active {
            transform: translateY(3px);
        }

        /* --------------------------- */
        /*  STAY (Hijau Glass)         */
        /* --------------------------- */
        .swal2-confirm {
            background: rgba(40, 150, 80, 0.45) !important;
            /* hijau transparan */
            border: 2px solid rgba(120, 230, 160, 0.5) !important;
            color: #fff !important;
            box-shadow:
                0 10px 18px rgba(0, 0, 0, 0.35),
                inset 0 6px 10px rgba(255, 255, 255, 0.20),
                inset 0 -6px 10px rgba(0, 0, 0, 0.35);
        }

        .swal2-confirm:hover {
            background: rgba(55, 180, 110, 0.55) !important;
        }

        /* --------------------------- */
        /*  OFF (Merah Glass)          */
        /* --------------------------- */
        .swal2-deny {
            background: rgba(180, 40, 60, 0.45) !important;
            /* merah transparan */
            border: 2px solid rgba(255, 150, 150, 0.5) !important;
            color: #fff !important;
        }

        .swal2-deny:hover {
            background: rgba(210, 55, 80, 0.55) !important;
        }

        /* --------------------------- */
        /*  Batal (Hitam Glass)        */
        /* --------------------------- */
        .swal2-cancel {
            background: rgba(20, 20, 20, 0.45) !important;
            /* hitam transparan */
            border: 2px solid rgba(180, 180, 180, 0.4) !important;
            color: #fff !important;
        }

        .swal2-cancel:hover {
            background: rgba(40, 40, 40, 0.55) !important;
        }


        /* Tombol shift 3D - Glass Navy Cembung */
        .swal-shift-btn {
            padding: 16px 20px;
            min-width: 80px;
            font-size: 18px;
            font-weight: 700;
            color: #ffffff;

            /* Tambahkan jarak antar tombol */
            margin: 0 6px;

            /* Glass navy */
            background: rgba(40, 60, 110, 0.45);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);

            border-radius: 18px;
            border: 2px solid rgba(180, 200, 255, 0.45);

            cursor: pointer;
            transition: 0.22s ease;

            /* --- Efek 3D tonjol keluar --- */
            box-shadow:
                0 12px 18px rgba(0, 0, 0, 0.45),
                inset 0 6px 10px rgba(255, 255, 255, 0.25),
                inset 0 -6px 10px rgba(0, 0, 0, 0.35),
                0 0 14px rgba(90, 120, 200, 0.5);
        }

        /* Hover: makin menonjol */
        .swal-shift-btn:hover {
            transform: translateY(-4px);
            box-shadow:
                0 16px 22px rgba(0, 0, 0, 0.55),
                inset 0 7px 11px rgba(255, 255, 255, 0.28),
                inset 0 -7px 11px rgba(0, 0, 0, 0.4),
                0 0 16px rgba(110, 140, 230, 0.6);
        }

        /* Active: ditekan */
        .swal-shift-btn:active {
            transform: translateY(3px);
            box-shadow:
                0 7px 10px rgba(0, 0, 0, 0.45),
                inset 0 3px 6px rgba(255, 255, 255, 0.18),
                inset 0 -4px 7px rgba(0, 0, 0, 0.35),
                0 0 12px rgba(90, 120, 200, 0.45);
        }

        /* Base styling untuk semua tombol SweetAlert */
        .swal2-popup .swal2-styled {
            padding: 14px 26px !important;
            font-size: 17px !important;
            font-weight: 700 !important;
            border-radius: 14px !important;
            backdrop-filter: blur(10px) !important;
            -webkit-backdrop-filter: blur(10px) !important;
            box-shadow:
                0 10px 18px rgba(0, 0, 0, 0.35),
                inset 0 5px 8px rgba(255, 255, 255, 0.22),
                inset 0 -5px 8px rgba(0, 0, 0, 0.30);
            transition: 0.22s ease !important;
        }

        /* Hover khusus SweetAlert */
        .swal2-popup .swal2-styled:hover {
            transform: translateY(-3px);
        }

        /* Active khusus SweetAlert */
        .swal2-popup .swal2-styled:active {
            transform: translateY(3px);
        }

        /* STAY / OK (Hijau Glass) */
        /* SweetAlert Confirm (OK) tengah sempurna */
        .swal2-popup .swal2-confirm {
            background: rgba(40, 150, 80, 0.45) !important;
            border: 2px solid rgba(120, 230, 160, 0.5) !important;
            color: #fff !important;

            padding: 14px 28px !important;
            /* lebih seimbang */

            /* perbaikan posisi text */
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;

            /* efek glass 3D tapi tidak membuat teks turun */
            box-shadow:
                0 6px 12px rgba(0, 0, 0, 0.35),
                /* bayangan bawah dikurangi */
                inset 0 4px 7px rgba(255, 255, 255, 0.25),
                /* highlight atas */
                inset 0 -3px 6px rgba(0, 0, 0, 0.25);
            /* shading bawah dikurangi */
        }

        /* OFF (Merah Glass) */
        .swal2-popup .swal2-deny {
            background: rgba(180, 40, 60, 0.45) !important;
            border: 2px solid rgba(255, 150, 150, 0.5) !important;
            color: #fff !important;
        }

        /* Batal (Hitam Glass) */
        .swal2-popup .swal2-cancel {
            background: rgba(20, 20, 20, 0.45) !important;
            border: 2px solid rgba(180, 180, 180, 0.4) !important;
            color: #fff !important;
        }

        /* Hilangkan garis animasi */
        .swal2-success-ring,
        .swal2-success-fix {
            background: none !important;
            display: none !important;
        }

        /* Hapus inner circle */
        .swal2-success-circular-line-left,
        .swal2-success-circular-line-right {
            display: none !important;
        }
    </style>
</head>

<body>

    <!-- HEADER MINI -->
    <div class="header-mini">
        <img src="img/tior.png" class="mini-logo">
        <button class="wa-btn" onclick="window.location.href='index.php'">Home</button>
    </div>


    <!-- PROFILE CARD -->
    <div class="profile-card">

        <div class="profile-title">Akun Saya</div>

        <div onclick="gantiFoto()" class="photo-frame">
            <?php if (!empty($data['foto'])): ?>
                <img src="uploads/<?= htmlspecialchars($data['foto']) ?>">
            <?php else: ?>
                <i class="fa-solid fa-user" style="font-size:52px; color:#fff;"></i>
            <?php endif; ?>
        </div>

        <!-- INFORMASI USER -->
        <div class="table-card">
            <table>
                <tr>
                    <th>Nama</th>
                    <td><?= htmlspecialchars($data['nama_asli']) ?></td>
                </tr>
                <tr>
                    <th>No HP</th>
                    <td><?= htmlspecialchars($data['no_handphone']) ?></td>
                </tr>
                <tr>
                    <th>Bank</th>
                    <td><?= htmlspecialchars($data['bank']) ?></td>
                </tr>
                <tr>
                    <th>No Rek</th>
                    <td><?= htmlspecialchars($data['no_rek']) ?></td>
                </tr>
            </table>
        </div>

        <a href="form_bank.php" class="gold-btn">Daftar Rekening / Ubah</a>

    </div>


    <h6 style="text-align:center; margin:20px 20px 20px 20px; color:#ccc;">
        Jika lupa password atau ingin ubah rekening, silakan hubungi Admin.
    </h6>

    <script>
        function gantiFoto() {
            Swal.fire({
                title: 'Foto Profil',
                html: '<b>Pilih tindakan</b>',
                icon: 'info',
                showCancelButton: true,
                showDenyButton: true,
                confirmButtonText: 'Ganti Foto',
                denyButtonText: 'Hapus Foto',
                cancelButtonText: 'Batal',
                background: '#1f4f82',
                color: '#fff',
                confirmButtonColor: '#ffd800',
                denyButtonColor: '#e74c3c'
            }).then((r) => {
                if (r.isConfirmed) {
                    window.location.href = "upload_foto.php";
                } else if (r.isDenied) {
                    Swal.fire({
                        title: 'Hapus Foto?',
                        text: 'Foto profil akan dihapus permanen.',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Ya, hapus',
                        cancelButtonText: 'Batal',
                        confirmButtonColor: '#e74c3c',
                    }).then((x) => {
                        if (x.isConfirmed) {
                            window.location.href = "hapus_foto.php?id=<?= $data['id'] ?>";
                        }
                    });
                }
            });
        }
    </script>

</body>

</html>