<?php
// ===========================
// DATA REKENING MANUAL
// ===========================
$bank      = "BCA";
$atas_nama = "Tior Delivery";
$no_rek    = "1234567890";

// File QR manual (pastikan ada)
$qr_file = "img/qr.jpg";
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>QR Pembayaran</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="css/navbar.css">

    <style>
        :root {
            --bg-navy: #071733;
            --gold1: #ffe680;
            --gold2: #ffcc00;
            --gold-shadow: #d1a700;
            --card-blue: #233a6a;
        }

        body {
            margin: 0;
            background: var(--bg-navy);
            font-family: 'Segoe UI', sans-serif;
            color: white;
            padding: 16px;
        }

        /* WRAPPER UTAMA */
        .main-wrapper {
            max-width: 360px;
            margin: auto;
            margin-top: 20px;
        }

        /* BOX GLASS GOLD */
        .glass-box {
            padding: 16px;
            background: rgba(173, 196, 255, 0.15);
            backdrop-filter: blur(14px) saturate(160%);
            border-radius: 16px;
            border: 1.5px solid rgba(255, 210, 90, 0.45);
            box-shadow:
                inset 0 1px 3px rgba(255, 255, 255, 0.35),
                inset 0 -2px 3px rgba(120, 80, 0, 0.20),
                0 6px 12px rgba(0, 0, 0, 0.28),
                0 0 12px rgba(255, 200, 60, 0.20);
            margin-bottom: 10px;
        }

        /* QR BORDER STYLE */
        .qr-wrapper {
            padding: 12px;
            border-radius: 14px;
            background: rgba(255, 255, 255, 0.15);
            border: 2px solid rgba(255, 255, 255, 0.25);
            display: flex;
            justify-content: center;
            margin-bottom: 18px;
            box-shadow:
                inset 0 1px 3px rgba(255, 255, 255, 0.3),
                inset 0 -1px 3px rgba(0, 0, 0, 0.25);
        }

        .qr-wrapper img {
            width: 260px;
            height: 260px;
            border-radius: 10px;
            background: white;
            padding: 8px;
        }

        /* TOMBOL GOLD 3D */
        .gold-btn {
            width: 100%;
            background: linear-gradient(var(--gold1), var(--gold2));
            border-radius: 14px;
            padding: 12px;
            color: #3a3300;
            font-weight: 800;
            font-size: 16px;
            border: none;
            cursor: pointer;
            box-shadow:
                0 6px 0 var(--gold-shadow),
                0 4px 12px rgba(0, 0, 0, 0.25),
                inset 0 2px 4px rgba(255, 255, 255, 0.45);
            transition: 0.22s;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
        }

        .gold-btn:hover {
            transform: translateY(-3px);
            box-shadow:
                0 8px 0 var(--gold-shadow),
                0 6px 14px rgba(0, 0, 0, 0.25),
                inset 0 2px 5px rgba(255, 255, 255, 0.5);
        }

        .gold-btn:active {
            transform: translateY(2px);
            box-shadow:
                0 3px 0 var(--gold-shadow),
                0 4px 6px rgba(0, 0, 0, 0.25),
                inset 0 3px 5px rgba(0, 0, 0, 0.25);
        }

        /* CARD DATA REKENING */
        .rekening-card {
            background: var(--card-blue);
            border-radius: 14px;
            padding: 16px;
            border: 3px solid rgba(255, 255, 255, 0.10);
            margin-top: 16px;
        }

        .rek-row {
            margin-bottom: 14px;
        }

        .label {
            font-size: 12px;
            color: #d4d4d4;
        }

        .value {
            font-size: 18px;
            font-weight: 700;
        }

        .copy-btn {
            background: white;
            border: 1px solid #ccc;
            padding: 6px 10px;
            border-radius: 8px;
            cursor: pointer;
        }

        /* SweetAlert2 - Navy Glassmorphism + Margin */
        .swal2-popup {
            background: rgba(30, 45, 80, 0.35) !important;
            backdrop-filter: blur(14px) !important;
            -webkit-backdrop-filter: blur(14px) !important;
            /* Margin agar ada jarak dari sisi layar */
            margin-left: 500px !important;
            margin-right: 500px !important;
            border: 2px solid rgba(90, 120, 180, 0.4);
            border-radius: 16px;
            color: #ffffff !important;
            font-size: 16px;
            box-shadow: 0 100px 28px rgba(0, 0, 0, 0.35);
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        /* Judul popup */
        .swal2-title {
            font-size: 20px;
            color: #ffffffff;
            text-align: center;
        }

        /* Input fields */
        .swal2-input {
            width: 100%;
            max-width: 250px;
            margin: 8px auto;
            background-color: #1e2329 !important;
            color: #ffffff !important;
            border: 1px solid #444 !important;
            border-radius: 8px;
            padding: 10px 12px;
            box-sizing: border-box;
        }

        /* Base styling untuk semua tombol SweetAlert */
        .swal2-styled {
            padding: 14px 26px !important;
            font-size: 17px !important;
            font-weight: 700 !important;
            border-radius: 14px !important;
            backdrop-filter: blur(10px) !important;
            -webkit-backdrop-filter: blur(10px) !important;
            box-shadow:
                0 10px 18px rgba(0, 0, 0, 0.35),
                inset 0 5px 8px rgba(255, 255, 255, 0.22),
                inset 0 -5px 8px rgba(0, 0, 0, 0.30);
            transition: 0.22s ease !important;
        }

        /* Hover umum */
        .swal2-styled:hover {
            transform: translateY(-3px);
        }

        /* Active umum */
        .swal2-styled:active {
            transform: translateY(3px);
        }

        /* --------------------------- */
        /*  STAY (Hijau Glass)         */
        /* --------------------------- */
        .swal2-confirm {
            background: rgba(40, 150, 80, 0.45) !important;
            /* hijau transparan */
            border: 2px solid rgba(120, 230, 160, 0.5) !important;
            color: #fff !important;
            box-shadow:
                0 10px 18px rgba(0, 0, 0, 0.35),
                inset 0 6px 10px rgba(255, 255, 255, 0.20),
                inset 0 -6px 10px rgba(0, 0, 0, 0.35);
        }

        .swal2-confirm:hover {
            background: rgba(55, 180, 110, 0.55) !important;
        }

        /* --------------------------- */
        /*  OFF (Merah Glass)          */
        /* --------------------------- */
        .swal2-deny {
            background: rgba(180, 40, 60, 0.45) !important;
            /* merah transparan */
            border: 2px solid rgba(255, 150, 150, 0.5) !important;
            color: #fff !important;
        }

        .swal2-deny:hover {
            background: rgba(210, 55, 80, 0.55) !important;
        }

        /* --------------------------- */
        /*  Batal (Hitam Glass)        */
        /* --------------------------- */
        .swal2-cancel {
            background: rgba(20, 20, 20, 0.45) !important;
            /* hitam transparan */
            border: 2px solid rgba(180, 180, 180, 0.4) !important;
            color: #fff !important;
        }

        .swal2-cancel:hover {
            background: rgba(40, 40, 40, 0.55) !important;
        }


        /* Tombol shift 3D - Glass Navy Cembung */
        .swal-shift-btn {
            padding: 16px 20px;
            min-width: 80px;
            font-size: 18px;
            font-weight: 700;
            color: #ffffff;

            /* Tambahkan jarak antar tombol */
            margin: 0 6px;

            /* Glass navy */
            background: rgba(40, 60, 110, 0.45);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);

            border-radius: 18px;
            border: 2px solid rgba(180, 200, 255, 0.45);

            cursor: pointer;
            transition: 0.22s ease;

            /* --- Efek 3D tonjol keluar --- */
            box-shadow:
                0 12px 18px rgba(0, 0, 0, 0.45),
                inset 0 6px 10px rgba(255, 255, 255, 0.25),
                inset 0 -6px 10px rgba(0, 0, 0, 0.35),
                0 0 14px rgba(90, 120, 200, 0.5);
        }

        /* Hover: makin menonjol */
        .swal-shift-btn:hover {
            transform: translateY(-4px);
            box-shadow:
                0 16px 22px rgba(0, 0, 0, 0.55),
                inset 0 7px 11px rgba(255, 255, 255, 0.28),
                inset 0 -7px 11px rgba(0, 0, 0, 0.4),
                0 0 16px rgba(110, 140, 230, 0.6);
        }

        /* Active: ditekan */
        .swal-shift-btn:active {
            transform: translateY(3px);
            box-shadow:
                0 7px 10px rgba(0, 0, 0, 0.45),
                inset 0 3px 6px rgba(255, 255, 255, 0.18),
                inset 0 -4px 7px rgba(0, 0, 0, 0.35),
                0 0 12px rgba(90, 120, 200, 0.45);
        }

        /* Hilangkan garis animasi */
        .swal2-success-ring,
        .swal2-success-fix {
            background: none !important;
            display: none !important;
        }

        /* Hapus inner circle */
        .swal2-success-circular-line-left,
        .swal2-success-circular-line-right {
            display: none !important;
        }
        h4 {
        text-align: center;
        margin:5px 0 20px 0;
        color:#ffcc00;
        }

    </style>

</head>

<body>

    <div class="main-wrapper">

        <div class="glass-box">

            <!-- QR -->
             <h4>QRIS : TIOR Delivery</h4>
            <div class="qr-wrapper">
                <img id="qrImage" src="<?= $qr_file ?>" alt="QR Code">
            </div>

            <!-- Tombol Download -->
            <button class="gold-btn" id="downloadBtn">
                <i class="fa-solid fa-download"></i> Download QR
            </button>

        </div>

        <!-- CARD REKENING -->
        <div class="rekening-card">

            <div class="rek-row">
                <div class="label">Bank</div>
                <div class="value"><?= $bank ?></div>
            </div>

            <div class="rek-row">
                <div class="label">Atas Nama</div>
                <div class="value"><?= $atas_nama ?></div>
            </div>

            <div class="rek-row" style="display:flex; justify-content:space-between; align-items:center;">
                <div>
                    <div class="label">No Rekening</div>
                    <div class="value" id="rekValue"><?= $no_rek ?></div>
                </div>

                <button class="copy-btn" id="copyBtn">
                    <i class="fa-regular fa-copy"></i>
                </button>
            </div>

        </div>

    </div>

    <script>
        // Download QR
        document.getElementById('downloadBtn').addEventListener('click', function() {
            const imgSrc = document.getElementById('qrImage').src;
            const a = document.createElement('a');
            a.href = imgSrc;
            a.download = "qrcode.png";
            document.body.appendChild(a);
            a.click();
            a.remove();
        });

        // Copy Rekening
        document.getElementById('copyBtn').addEventListener('click', function() {
            let text = document.getElementById('rekValue').innerText;
            navigator.clipboard.writeText(text);
            this.innerHTML = '<i class="fa-solid fa-check"></i>';
            setTimeout(() => {
                this.innerHTML = '<i class="fa-regular fa-copy"></i>';
            }, 1200);
        });

        // Download QR
        document.getElementById('downloadBtn').addEventListener('click', function() {
            const imgSrc = document.getElementById('qrImage').src;
            const a = document.createElement('a');
            a.href = imgSrc;
            a.download = "qrcode.png";
            document.body.appendChild(a);
            a.click();
            a.remove();
        });

        // Copy Rekening + SweetAlert
        document.getElementById('copyBtn').addEventListener('click', function() {
            let text = document.getElementById('rekValue').innerText;
            navigator.clipboard.writeText(text).then(() => {

                // icon berubah sementara
                document.getElementById('copyBtn').innerHTML = '<i class="fa-solid fa-check"></i>';

                // SWEETALERT
                Swal.fire({
                    icon: 'success',
                    title: 'Tersalin!',
                    text: 'Nomor rekening berhasil disalin.',
                    timer: 1400,
                    showConfirmButton: false,
                    background: 'rgba(30, 45, 80, 0.45)',
                    color: '#fff',
                    backdrop: `
                rgba(0,0,0,0.3)
            `,
                });

                setTimeout(() => {
                    document.getElementById('copyBtn').innerHTML = '<i class="fa-regular fa-copy"></i>';
                }, 1200);

            });
        });
    </script>
    <?php include 'navbar3.php'; ?>

</body>

</html>