<?php
include 'koneksi.php';
include 'auth.php';         // Mengecek login
include 'akses_ditolak.php'; // Tambahkan ini


$filter_nama = isset($_GET['nama']) ? $_GET['nama'] : '';

$query = "SELECT nama, no_handphone, SUM(tabungan_wajib) AS total_wajib FROM tabungan";
if ($filter_nama != '') {
    $query .= " WHERE nama LIKE '%$filter_nama%'";
}
$query .= " GROUP BY no_handphone ORDER BY nama ASC";

$result = mysqli_query($koneksi, $query);

$totalWajibQuery = "SELECT SUM(tabungan_wajib) AS total_wajib FROM tabungan";
$totalWajibResult = mysqli_query($koneksi, $totalWajibQuery);
$totalWajib = mysqli_fetch_assoc($totalWajibResult)['total_wajib'];
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <title>Rincian Tabungan Wajib</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/navbar.css">
    <link rel="stylesheet" href="css/tabungan.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
</head>
<style>
        thead th {
      position: sticky;
      top: 0;
      background-color: #333;
      color: #f5d216;
      z-index: 1;
    }
            td {
            padding-left:10px;
            padding:5px;
            border: 1px solid #333;
            text-align: left;
        }
</style>
<body>
    <div class="container">
        <h4>RINCIAN TABUNGAN WAJIB</h4>

        <!-- Search Bar -->
        <form method="GET" style="margin-bottom: 10px; display: flex; gap: 10px;">
            <input type="text" name="nama" placeholder="Cari nama..." value="<?= htmlspecialchars($filter_nama) ?>"
                style="flex: 1; padding: 8px 12px; border-radius: 6px; border: 1px solid #ccc;">
            <button type="submit"
                style="padding: 8px 16px; background-color: #f0ad00; border: none; border-radius: 6px; font-weight: bold;">Filter</button>
        </form>

        <form method="POST">
            <div class="input-button-group">
                <div class="input-wrapper">
                    <i class="fas fa-money-bill input-icon"></i>
                    <input  style="pointer-events: none;" type="text" value="Rp <?= number_format($totalWajib, 0, ',', '.') ?>" readonly>
                </div>
                <button type="button" class="action-btn"
                    onclick="window.location.href='rincian_tabungan_sukarela.php';">➥
                    Sukarela</button>
            </div>
        </form>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Total Tabungan</th>
                </tr>
            </thead>
            <tbody>
                <?php if (mysqli_num_rows($result) > 0): ?>
                    <?php while ($row = mysqli_fetch_assoc($result)):
                        $no_hp = $row['no_handphone'];
                        ?>
                        <tr>
                            <td>
                                <a
                                    onclick="toggleRincian('<?= $no_hp ?>', '<?= htmlspecialchars($row['nama'], ENT_QUOTES) ?>')">
                                    <?= htmlspecialchars($row['nama']) ?>
                                </a>
                            </td>
                            <td>Rp <?= number_format($row['total_wajib'], 0, ',', '.') ?></td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="2" style="text-align: center; color: red;">Nama tidak ditemukan</td>
                    </tr>
                <?php endif; ?>
            </tbody>

        </table>
    </div>
    <p style="text-align:center ; color: gray;">Klik Nama Member untuk detail Rincian</p>
    <?php include 'navbar4.php'; ?>
</body>

</html>

<script>
    function toggleRincian(no_hp, nama) {
        $.ajax({
            url: 'rincian_tabungan.php',
            type: 'GET',
            data: { no_hp: no_hp },
            success: function (data) {
                Swal.fire({
                    title: nama,
                    html: data,
                    width: '120%',
                    customClass: {
                        popup: 'rincian-popup'
                    },
                    showConfirmButton: true,
                    confirmButtonColor: '#FFD700'
                });
            },
            error: function () {
                Swal.fire('Error', 'Gagal mengambil data rincian.', 'error');
            }
        });
    }
</script>