<?php
include 'koneksi.php';


// Ambil data dari POST
$nama = $_POST['nama'] ?? '';
$no_hp = $_POST['no_handphone'] ?? '';
$wajib = intval($_POST['tabungan_wajib'] ?? 0);
$sukarela = intval($_POST['tabungan_sukarela'] ?? 0);
$total = $wajib + $sukarela;
$periode = $_POST['periode'] ?? '';

// Validasi data
if (empty($nama) || empty($no_hp) || $wajib < 5000) {
    echo json_encode(['success' => false, 'message' => 'Data tidak valid']);
    exit();
}

// Simpan ke database
$stmt = $koneksi->prepare("INSERT INTO tabungan (nama, no_handphone, tabungan_wajib, tabungan_sukarela, total_tabungan, periode) VALUES (?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssiiis", $nama, $no_hp, $wajib, $sukarela, $total, $periode);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'id_tabungan' => $stmt->insert_id]);
} else {
    echo json_encode(['success' => false, 'message' => 'Gagal menyimpan ke database']);
}

$stmt->close();
$koneksi->close();
?>