<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "koneksi.php";
session_start();

if (!isset($_SESSION['id'])) {
    header("Location: login.php");
    exit;
}

$id_user = (int) $_SESSION['id'];

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    header("Location: form_bank.php");
    exit;
}

// Ambil input
$bank      = isset($_POST['bank']) ? trim($_POST['bank']) : '';
$no_rek    = isset($_POST['no_rek']) ? trim($_POST['no_rek']) : '';
$atas_nama = isset($_POST['atas_nama']) ? trim($_POST['atas_nama']) : '';

// Validasi
$errors = [];
if ($bank === '') $errors[] = "Bank belum dipilih.";
if ($no_rek === '') $errors[] = "No rekening kosong.";
if ($atas_nama === '') $errors[] = "Nama rekening kosong.";
if (!preg_match('/^\d+$/', $no_rek)) $errors[] = "No rekening harus berupa angka.";

// ========== SWEETALERT ERROR ==========
if (!empty($errors)) {
    $error_html = nl2br(htmlspecialchars(implode("\n", $errors)));

    echo "<!doctype html>
    <html>
    <head>
        <meta charset='utf-8'>
        <title>Error</title>
        <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
    </head>
    <body style='background:#071733;'></body>

    <script>
    Swal.fire({
        icon: 'error',
        title: 'Validasi Gagal',
        html: `<div style='text-align:left; font-size:15px; color:#fff;'>$error_html</div>`,
        background: 'rgba(30,45,80,0.35)',
        color: '#fff',
        backdrop: true,
        confirmButtonText: 'OK',
        customClass: {
            confirmButton: 'swal2-confirm'
        }
    }).then(() => {
        window.location = 'form_bank.php';
    });
    </script>
    </html>";

    exit;
}

// ========== PROSES UPDATE ==========
$stmt = $koneksi->prepare("UPDATE user SET bank = ?, no_rek = ?, a_n = ? WHERE id = ?");
if (!$stmt) {

    $msg = addslashes($koneksi->error);

    echo "<!doctype html>
    <html>
    <head>
        <meta charset='utf-8'>
        <title>Error</title>
        <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
    </head>
    <body style='background:#071733;'></body>

    <script>
    Swal.fire({
        icon: 'error',
        title: 'Database Error',
        text: 'Prepare failed: {$msg}',
        background: 'rgba(30,45,80,0.35)',
        color: '#fff',
        customClass: {
            confirmButton: 'swal2-cancel'
        }
    }).then(() => {
        window.location = 'form_bank.php';
    });
    </script>
    </html>";

    exit;
}

$stmt->bind_param("sssi", $bank, $no_rek, $atas_nama, $id_user);

if ($stmt->execute()) {

    // ========== SWEETALERT SUKSES ==========
    echo "<!doctype html>
    <html>
    <head>
        <meta charset='utf-8'>
        <title>Sukses</title>
        <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
    </head>
    <body style='background:#071733;'></body>

    <script>
    Swal.fire({
        icon: 'success',
        title: 'Berhasil!',
        text: 'Data rekening berhasil disimpan.',
        background: 'rgba(30,45,80,0.35)',
        color: '#fff',
        customClass: {
            confirmButton: 'swal2-confirm'
        }
    }).then(() => {
        window.location = 'form_bank.php';
    });
    </script>
    </html>";

} else {

    // ========== SWEETALERT ERROR SAAT EXECUTE ==========
    $msg = addslashes($stmt->error);

    echo "<!doctype html>
    <html>
    <head>
        <meta charset='utf-8'>
        <title>Gagal</title>
        <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
    </head>
    <body style='background:#071733;'></body>

    <script>
    Swal.fire({
        icon: 'error',
        title: 'Gagal Menyimpan!',
        text: 'Kesalahan: {$msg}',
        background: 'rgba(30,45,80,0.35)',
        color: '#fff',
        customClass: {
            confirmButton: 'swal2-cancel'
        }
    }).then(() => {
        window.location = 'form_bank.php';
    });
    </script>
    </html>";
}

$stmt->close();
$koneksi->close();
exit;
