<?php
include "koneksi.php";
date_default_timezone_set('Asia/Jakarta');

// --- Ambil POST ---
$tanggal            = $_POST['tanggal'] ?? '';
$nama               = $_POST['nama'] ?? '';
$orderan            = isset($_POST['orderan']) ? intval($_POST['orderan']) : 0;
$total_ongkir       = isset($_POST['total_ongkir']) ? floatval($_POST['total_ongkir']) : 0;
$potongan           = isset($_POST['potongan']) ? floatval($_POST['potongan']) : 0;
$tabungan           = isset($_POST['tabungan']) ? floatval($_POST['tabungan']) : 0;
$total_setoran      = isset($_POST['total_setoran']) ? floatval($_POST['total_setoran']) : 0;
$total_pendapatan   = isset($_POST['total_pendapatan']) ? floatval($_POST['total_pendapatan']) : 0;
$now                = date('Y-m-d H:i:s');

// Konsumen dari JSON
$kcons = json_decode($_POST['konsumen_list'] ?? '[]', true);
if (!is_array($kcons)) $kcons = [];

if (empty($tanggal) || empty($nama)) {
    echo "Data tidak lengkap!";
    exit;
}

// --- Mulai Transaksi ---
$koneksi->begin_transaction();

try {

    // ─────────────────────────────────────────────
    // 1️⃣ CEK TRANSAKSI TERDAHULU (LOGIKA ANDA – TIDAK DIUBAH)
    // ─────────────────────────────────────────────

    $cek = $koneksi->prepare("
        SELECT id, waktu_simpan 
        FROM transaksi 
        WHERE nama = ? AND tanggal = ?
        ORDER BY waktu_simpan DESC LIMIT 1
    ");
    $cek->bind_param("ss", $nama, $tanggal);
    $cek->execute();
    $res  = $cek->get_result();
    $prev = $res->fetch_assoc();
    $cek->close();

    if ($prev) {

        $selisih = (strtotime($now) - strtotime($prev['waktu_simpan'])) / 3600;

        if ($selisih < 5) {

            // update jika < 5 jam
            $stmt = $koneksi->prepare("
                UPDATE transaksi SET
                    orderan = ?, total_ongkir = ?, potongan = ?, tabungan = ?, 
                    total_setoran = ?, total_pendapatan = ?, waktu_simpan = ?
                WHERE id = ?
            ");

            $stmt->bind_param(
                "idddddsi",
                $orderan, $total_ongkir, $potongan, $tabungan,
                $total_setoran, $total_pendapatan, $now, $prev['id']
            );
            $stmt->execute();
            $stmt->close();
            $msg = "Data diperbarui (< 5 jam)";

        } else {

            // Insert baru
            $stmt = $koneksi->prepare("
                INSERT INTO transaksi
                    (tanggal, nama, orderan, total_ongkir, potongan, tabungan, total_setoran, total_pendapatan, waktu_simpan)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
            ");

            $stmt->bind_param(
                "ssiddddds",
                $tanggal, $nama, $orderan, $total_ongkir, $potongan,
                $tabungan, $total_setoran, $total_pendapatan, $now
            );
            $stmt->execute();
            $stmt->close();
            $msg = "Data baru disimpan (> 5 jam)";
        }

    } else {

        // insert pertama kali
        $stmt = $koneksi->prepare("
            INSERT INTO transaksi
                (tanggal, nama, orderan, total_ongkir, potongan, tabungan, total_setoran, total_pendapatan, waktu_simpan)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");

        $stmt->bind_param(
            "ssiddddds",
            $tanggal, $nama, $orderan, $total_ongkir, $potongan,
            $tabungan, $total_setoran, $total_pendapatan, $now
        );
        $stmt->execute();
        $stmt->close();
        $msg = "Data baru disimpan!";
    }

    // ─────────────────────────────────────────────
    // 2️⃣ SIMPAN KONSUMEN (BAGIAN INI TOTAL SAYA PERBAIKI)
    // ─────────────────────────────────────────────

    if (!empty($kcons)) {

        // Insert 1 baris per order (TANPA CEK DUPLIKASI)
        $insK = $koneksi->prepare("
            INSERT INTO konsumen (nama_konsumen, created_at)
            VALUES (?, NOW())
        ");

        foreach ($kcons as $row) {

            if (!isset($row['nama'])) continue;

            $nama_kons = trim($row['nama']);
            if ($nama_kons === "") continue;

            // Abaikan jika dicoret
            if (isset($row['coret']) && $row['coret'] == true) continue;

            $insK->bind_param("s", $nama_kons);
            $insK->execute();
        }

        $insK->close();
    }

    // ─────────────────────────────────────────────
    // 3️⃣ SELESAIKAN TRANSAKSI
    // ─────────────────────────────────────────────
    $koneksi->commit();
    echo $msg;

} catch (Exception $e) {

    $koneksi->rollback();
    echo "ERROR: " . $e->getMessage();
}

?>
