<?php
include 'koneksi.php';
include 'auth.php'; // Cek login
include 'akses_ditolak.php'; // Tambahkan ini



// Ambil data JSON dari input
$data = json_decode(file_get_contents('php://input'), true);

if (!$data) {
    echo json_encode(['success' => false, 'message' => 'Data tidak valid']);
    exit;
}

$tanggal = $data['tanggal'] ?? null;
$total_orderan = $data['total_orderan'] ?? null;
$total_driver = $data['total_driver'] ?? null;

// Validasi sederhana
if (!$tanggal || !is_numeric($total_orderan) || !is_numeric($total_driver)) {
    echo json_encode(['success' => false, 'message' => 'Data tidak lengkap atau tidak valid']);
    exit;
}

// Insert ke database
$stmt = $koneksi->prepare("INSERT INTO orders (tanggal, total_orderan, total_driver) VALUES (?, ?, ?)");
$stmt->bind_param("sii", $tanggal, $total_orderan, $total_driver);

if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Gagal menyimpan data']);
}
?>
