<?php
include 'koneksi.php';
date_default_timezone_set("Asia/Jakarta");

// Filter rentang tanggal
$tgl_mulai   = $_GET['tgl_mulai']   ?? '';
$tgl_selesai = $_GET['tgl_selesai'] ?? '';

// Query utama
$query = "SELECT nama_konsumen, COUNT(*) AS total_order 
          FROM konsumen 
          WHERE 1=1";

if ($tgl_mulai && $tgl_selesai) {
    $query .= " AND DATE(created_at) BETWEEN '$tgl_mulai' AND '$tgl_selesai'";
}

$query .= " GROUP BY nama_konsumen ORDER BY total_order DESC";
$result = mysqli_query($koneksi, $query);
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Total Order Konsumen</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0" />

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="css/navbar.css">

<style>
body {
    font-family: 'Segoe UI', Roboto, Arial;
    margin: 10px;
    background: #071733;
    font-weight: bold;
    color: #fed054;
}

h4 {
    text-align: center;
    margin-top: 15px;
    margin-bottom: 15px;
}

/* FILTER BOX */
.filter-box {
    background: rgba(255,255,255,0.08);
    padding: 15px;
    border-radius: 10px;
    border: 1px solid rgba(255,255,255,0.25);
}

/* Input tanggal */
.date-row {
    display: flex;
    gap: 12px;
    margin-bottom: 12px;
}

.date-row input[type="date"] {
    flex: 1;
    height: 50px;
    padding: 0 14px;
    font-size: 15px;
    border-radius: 8px;
    border: 2px solid rgba(255,255,255,0.25);
    background: rgba(255,255,255,0.20);
    color: #fed054;
    text-align: center;
    box-sizing: border-box;
}

/* Tombol sejajar */
.btn-row {
    display: flex;
    gap: 12px;
}

.btn-row button {
    flex: 1;
    height: 40px;
    border-radius: 8px;
    border: none;
    background: linear-gradient(#ffe680,#ffcc00);
    color: #1e2329;
    font-weight: bold;
    font-size: 16px;

    box-shadow:
        0 6px 0 #d1a700,
        0 4px 10px rgba(0,0,0,0.18),
        inset 0 2px 4px rgba(255,255,255,0.45);
    transition: 0.2s;
}
.btn-row button:hover {
    transform: translateY(-3px);
    box-shadow:
        0 9px 0 #d1a700,
        0 6px 14px rgba(0,0,0,0.24),
        inset 0 2px 5px rgba(255,255,255,0.5);
}
.btn-row button:active {
    transform: translateY(2px);
}

/* LIVE SEARCH BOX */
.search-box {
    margin-bottom: 10px;
    padding: 0 0px 0 0px;       /* ⭐ Tambahan agar tidak mepet kiri kanan */
}

.search-box input {
    width: 100%;
    height: 40px;
    padding: 0 14px;
    border-radius: 8px;
    border: 2px solid rgba(255,255,255,0.25);
    background: rgba(255,255,255,0.20);
    color: #fed054;
    font-size: 15px;
    text-align: center;
    box-sizing: border-box;
}


/* TABLE AREA */
.table-container {
    max-height: 55vh;
    min-height: 55vh;
    overflow-y: auto;
    background: #ffffff;
    border-radius: 6px;
    margin-top: 15px;
    border: 1px solid #2a2f35;
}

table {
    width: 100%;
    border-collapse: collapse;
    background: #ececec;
    font-size: 14px;
}

thead th {
    background: #233a6a;
    color: #f5d216;
    padding: 8px;
    position: sticky;
    top: 0;
    z-index: 1;
}

tbody td {
    padding: 8px;
    text-align: center;
    border: 1px solid rgba(255,255,255,0.4);
    color: #1e2329;
}

/* MOBILE RESPONSIVE */
@media (max-width: 480px) {
    .date-row input[type="date"] { height: 38px; font-size: 14px; }
    .btn-row button { height: 36px; font-size: 14px; }
    .search-box input { height: 36px; font-size: 14px; }
}
</style>

</head>
<body>

<h4>KONSUMEN LOYALITY</h4>

<!-- FILTER BOX -->
<div class="filter-box">
    <form method="GET">

        <!-- LIVE SEARCH -->
        <div class="search-box">
            <input type="text" id="searchInput" placeholder="Cari konsumen...">
        </div>

        <div class="date-row">
            <input type="date" name="tgl_mulai" placeholder="Dari Tanggal" value="<?= $tgl_mulai ?>">
            <input type="date" name="tgl_selesai" placeholder="Sampai Tanggal" value="<?= $tgl_selesai ?>">
        </div>

        <div class="btn-row">
            <button type="submit">Filter</button>
            <button type="button" onclick="window.location='total_order.php'">Reset</button>
        </div>

    </form>
</div>

<!-- TABLE -->
<div class="table-container">
<table id="orderTable">
    <thead>
        <tr>
            <th>Konsumen</th>
            <th>Total Order</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = mysqli_fetch_assoc($result)) { ?>
        <tr>
            <td><?= $row['nama_konsumen'] ?></td>
            <td><?= $row['total_order'] ?></td>
        </tr>
        <?php } ?>
    </tbody>
</table>
</div>

<?php include 'navbar4.php'; ?>

<script>
// ==========================
// LIVE SEARCH FUNCTION
// ==========================
document.getElementById("searchInput").addEventListener("keyup", function() {
    let filter = this.value.toLowerCase();
    let rows = document.querySelectorAll("#orderTable tbody tr");

    rows.forEach(row => {
        let nama = row.cells[0].innerText.toLowerCase();
        row.style.display = nama.includes(filter) ? "" : "none";
    });
});
</script>

</body>
</html>
