<?php
include 'koneksi.php';
include 'auth.php';
include 'akses_ditolak.php';

// Ambil parameter offset minggu dari URL
$minggu_offset = isset($_GET['minggu']) ? (int)$_GET['minggu'] : 0;

$hari_ini = date('Y-m-d');
$hari_keberapa = date('w');
$selisih = ($hari_keberapa >= 5) ? $hari_keberapa - 5 : 7 - (5 - $hari_keberapa);

// Jumat terakhir sebagai awal minggu
$awal_minggu = date('Y-m-d', strtotime("-$selisih days", strtotime($hari_ini)));
$awal_minggu = date('Y-m-d', strtotime("{$minggu_offset} week", strtotime($awal_minggu)));
$akhir_minggu = date('Y-m-d', strtotime('+6 days', strtotime($awal_minggu)));

// Opsional: batasi jika mencoba lihat ke masa depan
if (strtotime($awal_minggu) > strtotime($hari_ini)) {
    header("Location: ?minggu=" . ($minggu_offset - 1));
    exit;
}

$target = 80;

$query = "SELECT nama, SUM(orderan) AS total_orderan 
          FROM transaksi 
          WHERE tanggal BETWEEN ? AND ? 
          GROUP BY nama 
          ORDER BY total_orderan DESC";
$stmt = $koneksi->prepare($query);
$stmt->bind_param("ss", $awal_minggu, $akhir_minggu);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Total Orderan Mingguan</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="css/navbar.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <style>
        body {
            background: #071733;
            color: #f1f1f1;
            font-family: 'Segoe UI', sans-serif;
            margin: 0;
            padding: 10px;
        }

        p {
            text-align: center;
            font-size: 16px;
            margin-top: 10px;
        }

        .table-container {
            max-height: 55vh;
            min-height: 55vh;
            overflow-y: auto;
            margin-top: 20px;
            border: 1px solid rgba(255, 255, 255, 0.659);
            position: relative;
            background-color: rgb(255, 255, 255);
            z-index: 1
        }

        table {
            width: 100%;
            color: #1e2329;
            table-layout: fixed;
            font-size: 14px;
            border-collapse: collapse;
            background-color: rgb(236, 236, 236);
        }

        thead th,
        tbody td {
            padding: 6px;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.659);
        }

        th {
            padding: 12px;
            color: #f5d216;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.659);
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        td {
            text-align: center;
        }

        th {
            background: #233a6a;
        }

        td.nama {
            max-width: 80px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
            text-align: left;
        }

        .badge {
            padding: 6px 10px;
            border-radius: 20px;
            font-weight: bold;
            font-size: 0.9em;
            display: inline-block;
        }

        .badge-sukses {
            background-color: #4caf50;
            color: white;
        }

        .badge-progres {
            background-color: #ffca28;
            color: black;
        }

        @media (max-width: 600px) {
            body {
                font-size: 14px;
            }

            th,
            td {
                padding: 8px;
            }

            .badge {
                font-size: 0.8em;
                padding: 4px 8px;
            }

            td.nama {
                max-width: 90px;
            }
        }

        td.no,
        th.no {
            width: 20px;
            max-width: 20px;
            text-align: center;
        }

        th.target,
        td.target {
            width: 50px;
            max-width: 50px;
            min-width: 40px;
            text-align: center;
            white-space: nowrap;
        }

        h3 {
            text-align: center;
            color: #fed054;
            margin-bottom: 10px;
        }

        h4 {
            text-align: center;
            padding: 20px;
            align-items: center;
            background: rgba(255, 255, 255, 0.2);
            border: 3px solid rgba(255, 255, 255, 0.35);
            border-radius: 10px;
            color: #fed054;
            font-size: 18px;
            margin-bottom: 10px;
        }

        .navigasi-minggu {
            text-align: center;
            margin: 10px 0 20px;
        }

        .navigasi-minggu a {
            color: #facc15;
            margin: 0 20px;
            text-decoration: none;
            font-weight: bold;
        }

        .navigasi-minggu a:hover {
            text-decoration: underline;
        }
    </style>

    <?php include 'navbar4.php'; ?>
</head>

<body>
    <h3>Weekly Reward</h3>
    <p>Periode: <?= date('d M Y', strtotime($awal_minggu)) ?> - <?= date('d M Y', strtotime($akhir_minggu)) ?></p>

    <div class="navigasi-minggu">
        <?php
        $sebelumnya = $minggu_offset - 1;
        $berikutnya = $minggu_offset + 1;
        ?>
        <a href="?minggu=<?= $sebelumnya ?>"><i class="fa-solid fa-arrow-left"></i> Minggu Lalu</a>
        <a href="?minggu=<?= $berikutnya ?>">Minggu Depan <i class="fa-solid fa-arrow-right"></i></a>
    </div>

    <h4>Target Driver : <strong><?= $target ?> Orderan</strong></h4>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th class="no">No</th>
                    <th>Nama</th>
                    <th class="target">Target</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $no = 1;
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        $total = (int)$row['total_orderan'];
                        $status = ($total >= $target)
                            ? "<span class='badge badge-sukses'>SUKSES</span>"
                            : "<span class='badge badge-progres'>PROGRES</span>";
                        echo "<tr>
                            <td class='no'>{$no}</td>
                            <td class='nama' title='" . htmlspecialchars($row['nama']) . "'>" . htmlspecialchars($row['nama']) . "</td>
                            <td>{$total}</td>
                            <td>{$status}</td>
                        </tr>";
                        $no++;
                    }
                } else {
                    echo "<tr><td colspan='4'>Belum ada data untuk periode ini.</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</body>

</html>