<?php
session_start();
include "koneksi.php";

if (!isset($_SESSION['id'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Upload Foto Profil</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <!-- Cropper.js -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
</head>

<style>
/* ============================
     GLOBAL THEME NAVY GOLD
============================ */
body {
    margin: 0;
    background: #071733;
    font-family: 'Poppins', sans-serif;
    color: #fff;
}

/* ============================
      WRAPPER CARD
============================ */
.upload-card {
    max-width: 420px;
    margin: 40px auto;
    padding: 25px 20px;
    background: #233a6a;
    border: 3px solid rgba(255,255,255,0.18);
    border-radius: 14px;

    box-shadow:
        0 10px 0 rgba(0,0,0,0.35),
        inset 0 1px 4px rgba(255,255,255,0.25);

    text-align: center;
}

/* ============================
      TITLE & DESCRIPTION
============================ */
.upload-title {
    color: #ffd800;
    font-size: 22px;
    font-weight: 700;
    margin-bottom: 5px;
}

.upload-desc {
    color: #e6e6e6;
    font-size: 14px;
    margin-bottom: 18px;
}

/* ============================
   INPUT FILE (GLASS NAVY)
============================ */
.upload-input {
    background: rgba(40,60,110,0.45) !important;
    color: #fff !important;
    border: 2px solid rgba(180,200,255,0.35) !important;
    border-radius: 12px !important;
    padding: 10px 14px !important;

    backdrop-filter: blur(8px) !important;
    -webkit-backdrop-filter: blur(8px) !important;

    font-size: 14px !important;
}

.upload-input::file-selector-button {
    background: rgba(255,255,255,0.12);
    color: #fff;
    border: none;
    padding: 8px 14px;
    border-radius: 8px;
    margin-right: 12px;
    cursor: pointer;

    box-shadow:
        inset 0 2px 4px rgba(255,255,255,0.25),
        0 2px 6px rgba(0,0,0,0.25);
}

.upload-input::file-selector-button:hover {
    background: rgba(255,255,255,0.22);
}

/* ============================
      PREVIEW BOX (SEBELUM CROP)
============================ */
.image-preview-box {
    margin-top: 18px;
    padding: 10px;
    background: rgba(0,0,0,0.25);
    border: 2px solid rgba(255,255,255,0.15);
    border-radius: 14px;
    display:none;

    backdrop-filter: blur(6px);
    -webkit-backdrop-filter: blur(6px);

    box-shadow:
        inset 0 1px 3px rgba(255,255,255,0.25),
        0 6px 16px rgba(0,0,0,0.35);
}

#previewImage {
    max-width: 100%;
    border-radius: 10px;
}

/* tombol OK/Batal preview */
.preview-action-btns {
    margin-top: 12px;
    display: flex;
    justify-content: center;
    gap: 12px;
}

/* ============================
      CROP BOX AREA
============================ */
.image-crop-box {
    margin-top: 18px;
    padding: 10px;
    background: rgba(0,0,0,0.25);
    border: 2px solid rgba(255,255,255,0.15);
    border-radius: 14px;
    display:none;

    backdrop-filter: blur(6px);
    -webkit-backdrop-filter: blur(6px);
}

#cropImage {
    max-width: 100%;
    border-radius: 10px;
}

/* ============================
      CROP BOX LINGKARAN FIX
============================ */
.cropper-view-box {
    border-radius: 50% !important;
    border: 2px solid #ffd800 !important;
    box-shadow: 0 0 12px rgba(255,215,0,0.7);
}

.cropper-face {
    border-radius: 50% !important;
    background: transparent !important;
}

.cropper-line,
.cropper-point,
.cropper-dashed {
    display: none !important;
}

.cropper-container:after {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;

    background: radial-gradient(circle,
        transparent 55%,
        rgba(0,0,0,0.55) 57%
    );
}

/* tombol crop */
.crop-action-btns {
    margin-top: 12px;
    display: flex;
    justify-content: center;
    gap: 12px;
}

/* ============================
      TOMBOL SWEETALERT STYLE
============================ */
.swal-crop-ok {
    padding: 12px 28px;
    font-size: 16px;
    font-weight: 700;
    border-radius: 12px;
    color: #fff;

    background: rgba(40, 150, 80, 0.45);
    border: 2px solid rgba(120,230,160,0.5);

    backdrop-filter: blur(8px);
    cursor: pointer;
    transition: 0.22s ease;

    box-shadow:
        0 10px 18px rgba(0,0,0,0.35),
        inset 0 5px 8px rgba(255,255,255,0.22),
        inset 0 -5px 8px rgba(0,0,0,0.30);
}
.swal-crop-ok:hover {
    transform: translateY(-3px);
    background: rgba(55, 180, 110, 0.55);
}
.swal-crop-ok:active {
    transform: translateY(2px);
}

.swal-crop-cancel {
    padding: 12px 28px;
    font-size: 16px;
    font-weight: 700;
    border-radius: 12px;
    color: #fff;

    background: rgba(20,20,20,0.45);
    border: 2px solid rgba(180,180,180,0.4);

    backdrop-filter: blur(8px);
    cursor: pointer;
    transition: 0.22s ease;

    box-shadow:
        0 8px 16px rgba(0,0,0,0.35),
        inset 0 4px 6px rgba(255,255,255,0.18),
        inset 0 -4px 7px rgba(0,0,0,0.30);
}
.swal-crop-cancel:hover {
    transform: translateY(-3px);
    background: rgba(40,40,40,0.55);
}
.swal-crop-cancel:active {
    transform: translateY(2px);
}

/* ============================
      BACK BUTTON
============================ */
.back-btn {
    display: block;
    width: 100%;
    margin-top: 20px;
    padding: 12px;

    border-radius: 12px;
    background: rgba(20,20,20,0.45);
    border: 2px solid rgba(180,180,180,0.35);
    color: #fff;
    font-weight: 600;

    backdrop-filter: blur(7px);

    box-shadow:
        0 6px 12px rgba(0,0,0,0.25),
        inset 0 3px 5px rgba(255,255,255,0.15),
        inset 0 -3px 6px rgba(0,0,0,0.25);

    transition: 0.2s;
}

.back-btn:hover {
    transform: translateY(-3px);
    background: rgba(40,40,40,0.55);
}

.back-btn:active {
    transform: translateY(2px);
}
</style>

<body>

<div class="container mt-4">
    <div class="upload-card">

        <h3 class="upload-title">Upload Foto Profil</h3>
        <p class="upload-desc">Pilih file PNG/JPG/JPEG</p>

        <!-- INPUT FILE -->
        <input type="file" id="fotoInput" class="upload-input" accept="image/*">

        <!-- PREVIEW FOTO (belum crop) -->
        <div class="image-preview-box" id="previewBox">
            <img id="previewImage">

            <div class="preview-action-btns">
                <button class="swal-crop-ok" onclick="startCrop()">OK</button>
                <button class="swal-crop-cancel" onclick="cancelPreview()">Batal</button>
            </div>
        </div>

        <!-- AREA CROPPER -->
        <div class="image-crop-box" id="cropBox">
            <img id="cropImage">

            <div class="crop-action-btns">
                <button class="swal-crop-ok" onclick="confirmCrop()">Crop</button>
                <button class="swal-crop-cancel" onclick="cancelCrop()">Batal</button>
            </div>
        </div>

        <a href="profil.php" class="back-btn">Kembali</a>

    </div>
</div>

<script>
let cropper;
const fileInput = document.getElementById("fotoInput");
const previewBox = document.getElementById("previewBox");
const cropBox = document.getElementById("cropBox");
const previewImage = document.getElementById("previewImage");
const cropImage = document.getElementById("cropImage");

/* ====================================
   USER PILIH FOTO → TAMPIL PREVIEW
==================================== */
fileInput.addEventListener("change", function(e) {
    const file = e.target.files[0];
    if (!file) return;

    const reader = new FileReader();
    reader.onload = function(evt) {
        previewImage.src = evt.target.result;

        previewBox.style.display = "block";
        cropBox.style.display = "none"; // hide cropper
    };
    reader.readAsDataURL(file);
});

/* ====================================
   TOMBOL OK → MASUK KE CROP MODE
==================================== */
function startCrop() {
    cropImage.src = previewImage.src;

    previewBox.style.display = "none";
    cropBox.style.display = "block";

    if (cropper) cropper.destroy();

    cropper = new Cropper(cropImage, {
        aspectRatio: 1,
        viewMode: 0,
        background: false,
        dragMode: 'move',
        autoCrop: true,
        autoCropArea: 0,

        ready() {
            const size = 300;
            const container = this.cropper.getContainerData();

            setTimeout(() => {
                this.cropper.setCropBoxData({
                    width: size,
                    height: size,
                    left: (container.width - size) / 2,
                    top: (container.height - size) / 2
                });
            }, 30);
        }
    });
}

/* ====================================
   TOMBOL BATAL PREVIEW
==================================== */
function cancelPreview() {
    previewBox.style.display = "none";
    fileInput.value = "";
}

/* ====================================
   TOMBOL BATAL CROP
==================================== */
function cancelCrop() {
    cropBox.style.display = "none";
    previewBox.style.display = "block";

    if (cropper) cropper.destroy();
}

/* ====================================
   PROSES CROP → PNG LINGKARAN → UPLOAD
==================================== */
function confirmCrop() {
    if (!cropper) return;

    const squareCanvas = cropper.getCroppedCanvas({
        width: 500,
        height: 500
    });

    const circleCanvas = document.createElement("canvas");
    const size = 500;
    circleCanvas.width = size;
    circleCanvas.height = size;

    const ctx = circleCanvas.getContext("2d");
    ctx.beginPath();
    ctx.arc(size/2, size/2, size/2, 0, Math.PI * 2);
    ctx.closePath();
    ctx.clip();

    ctx.drawImage(squareCanvas, 0, 0, size, size);

    circleCanvas.toBlob(function(blob) {
        const formData = new FormData();
        formData.append("foto", blob, "profile.png");

        fetch("proses_upload_foto.php", {
            method: "POST",
            body: formData
        })
        .then(res => res.text())
        .then(() => {
            Swal.fire({
                title: "Berhasil!",
                text: "Foto profil berhasil diupload.",
                icon: "success"
            }).then(() => {
                window.location.href = "profil.php";
            });
        })
        .catch(() => {
            Swal.fire("Error", "Upload gagal!", "error");
        });
    }, "image/png", 0.7);
}
</script>

</body>
</html>
